/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JTextFieldLabel;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14 $
 */
public class FSAIntegerFieldLabel extends FSATextFieldLabel
{
   /**
    * Constructor for class FSAIntegerFieldLabel
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSAIntegerFieldLabel (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
   }


   /**
    * Constructor for class FSAIntegerFieldLabel
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAIntegerFieldLabel (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JTextFieldLabel txt = new JTextFieldLabel (true);

      txt.setBackground (COLOR_BACKGROUND);
      txt.setForeground (COLOR_FOREGROUND);
      txt.setBorder (null);
      //      txt.setAutoCloaking (true);

      return  (txt);
   }


   /**
    * Get the defaultAttrName attribute of the FSAIntegerFieldLabel object
    *
    * @return   The defaultAttrName value
    */
   public String getDefaultAttrName()
   {
      return "number";
   }


   /**
    * Sets the horizontalAlignment attribute of the FSAIntegerFieldLabel object
    *
    * @param align  The new horizontalAlignment value
    */
   public void setHorizontalAlignment (int align)
   {
      JTextFieldLabel txt = (JTextFieldLabel) getJComponent();
      txt.setHorizontalAlignment (align);
   }


   /**
    * Get the horizontalAlignment attribute of the FSAIntegerFieldLabel object
    *
    * @return   The horizontalAlignment value
    */
   public int getHorizontalAlignment()
   {
      JTextFieldLabel txt = (JTextFieldLabel) getJComponent();

      return txt.getHorizontalAlignment();
   }
}

/*
 * $Log: FSAIntegerFieldLabel.java,v $
 * Revision 1.14  2004/11/03 10:17:52  lowende
 * Javadoc warnings removed.
 *
 */
