/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * Fujaba Swing Adapter JFrame
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class FSAFrame
    extends FSAObject
{
   /**
    * Constructor for class FSAFrame
    */
   public FSAFrame()
   {
      super (null, null, null, null);
   }


   /**
    * Constructor for class FSAFrame
    *
    * @param incr  No description provided
    */
   public FSAFrame (LogicUnparseInterface incr)
   {
      super (incr, null, null, null);
   }


   /**
    * Constructor for class FSAFrame
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSAFrame (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName, null, null);
   }


   /**
    * create JFrame, using JFrame.getRootPane () as JComponent
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JFrame frame = new JFrame();

      JRootPane rootPane = frame.getRootPane();

      return  (rootPane);
   }


   /**
    * Sets the jComponentValue attribute of the FSAFrame object
    *
    * @param value  The new jComponentValue value
    */
   public void setJComponentValue (Object value)
   {

   }


   /**
    * Get the jComponentValue attribute of the FSAFrame object
    *
    * @return   The jComponentValue value
    */
   public Object getJComponentValue()
   {
      return null;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "FSAFrame";
   }

}

/*
 * $Log: FSAFrame.java,v $
 * Revision 1.12  2004/11/03 10:17:52  lowende
 * Javadoc warnings removed.
 *
 */
