/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.event.ItemListener;
import java.util.*;

import javax.swing.*;
import javax.swing.border.LineBorder;

import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.ComboBoxUpdater;
import de.upb.tools.fca.FEmptyIterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.20 $
 */
public class FSAComboBox extends FSAObject
{
   /**
    * Constructor for class FSAComboBox
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSAComboBox (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
   }


   /**
    * Constructor for class FSAComboBox
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAComboBox (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Get the defaultUpdaterClass attribute of the FSAComboBox object
    *
    * @return   The defaultUpdaterClass value
    */
   public Class getDefaultUpdaterClass()
   {
      return ComboBoxUpdater.class;
   }


   /**
    * Get the defaultAttrName attribute of the FSAComboBox object
    *
    * @return   The defaultAttrName value
    */
   public String getDefaultAttrName()
   {
      return "selectedItem";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JComboBox box = new JComboBox();
      box.setBackground (COLOR_BACKGROUND);
      box.setForeground (COLOR_FOREGROUND);
      box.setBorder (new LineBorder (COLOR_FOREGROUND));

      return  (box);
   }


   /**
    * @return   Number of items that are shown by the ComboBox
    */
   public int sizeOfItems()
   {
      JComboBox comp = (JComboBox) getJComponent();

      if (comp != null)
      {
         return comp.getItemCount();
      }
      else
      {
         return 0;
      }
   }


   /**
    * @return   an iterator over the items shown in the ComboBox
    */
   public Iterator iteratorOfItems()
   {
      JComboBox comp = (JComboBox) getJComponent();

      if (comp != null)
      {
         int size = sizeOfItems();
         Object[] items = new Object[size];

         for (int i = 0; i < size; i++)
         {
            items[i] = comp.getItemAt (i);
         }
         return Arrays.asList (items).iterator();
      }
      else
      {
         return FEmptyIterator.get();
      }
   }


   /**
    * @param item  No description provided
    * @return      true if item is shown by the ComboBox
    */
   public boolean hasInItems (Object item)
   {
      boolean found = false;
      Iterator iter = iteratorOfItems();

      while (iter.hasNext() && !found)
      {
         Object elem = iter.next();
         found = elem.equals (item);
      }

      return found;
   }


   /**
    * remove item from the list of Objects shown by the ComboBox
    *
    * @param item  No description provided
    */
   public void removeFromItems (Object item)
   {
      JComboBox comp = (JComboBox) getJComponent();

      if (comp != null)
      {
         comp.removeItem (item);
      }
   }


   /**
    * the item is added to the list of items shown by the ComboBox
    *
    * @param item  The object added.
    */
   public void addToItems (Object item)
   {
      JComboBox comp = (JComboBox) getJComponent();

      if (!hasInItems (item))
      {
         comp.addItem (item);
      }
   }


   /**
    * Sets the selectedItem attribute of the FSAComboBox object
    *
    * @param item  The new selectedItem value
    */
   public void setSelectedItem (Object item)
   {
      JComboBox comp = (JComboBox) getJComponent();

      comp.setSelectedItem (item);
   }


   /**
    * Get the selectedItem attribute of the FSAComboBox object
    *
    * @return   The selectedItem value
    */
   public Object getSelectedItem()
   {
      JComboBox comp = (JComboBox) getJComponent();

      return comp.getSelectedItem();
   }


   /**
    * Sets the selectedIndex attribute of the FSAComboBox object
    *
    * @param index  The new selectedIndex value
    */
   public void setSelectedIndex (int index)
   {
      JComboBox comp = (JComboBox) getJComponent();

      comp.setSelectedIndex (index);
   }


   /**
    * Get the selectedIndex attribute of the FSAComboBox object
    *
    * @return   The selectedIndex value
    */
   public int getSelectedIndex()
   {
      JComboBox comp = (JComboBox) getJComponent();

      return comp.getSelectedIndex();
   }


   /**
    * Access method for an one to n association.
    *
    * @param listener  The object added.
    */
   public void addItemListener (ItemListener listener)
   {
      JComboBox box = (JComboBox) getJComponent();
      box.addItemListener (listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param listener  No description provided
    */
   public void removeItemListener (ItemListener listener)
   {
      JComboBox box = (JComboBox) getJComponent();
      box.removeItemListener (listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfItemListeners()
   {
      EventListener[] listeners = getJComponent().getListeners (ItemListener.class);
      return Arrays.asList (listeners).iterator();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      JComboBox comp = (JComboBox) getJComponent();

      if (comp != null)
      {
         comp.removeAllItems();
      }
      super.removeYou();
   }
}

/*
 * $Log: FSAComboBox.java,v $
 * Revision 1.20  2004/11/03 10:17:51  lowende
 * Javadoc warnings removed.
 *
 */
