/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;

import javax.swing.JComponent;

import de.uni_paderborn.fujaba.fsa.swing.JCollapsable;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.metamodel.FClass;


/**
 * UMLClass: 'FSAPanel'
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.27.2.3 $
 */
public class FSACollapsable extends FSAPanel implements PropertyChangeListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String COLLAPSED = "collapsed";


   /**
    * Calls the constructor FSAPanel(incr, propName, parent) with propName =
    * "collapsed" and parent = null.
    *
    * @param incr  No description provided
    */
   public FSACollapsable (LogicUnparseInterface incr)
   {
      this (incr, "collapsed", null);
   }


   /**
    * Calls the constructor FSAPanel(incr, propName, parent) with propName =
    * "collapsed".
    *
    * @param incr    No description provided
    * @param parent  No description provided
    */
   public FSACollapsable (LogicUnparseInterface incr, JComponent parent)
   {
      this (incr, "collapsed", parent);
   }


   /**
    * Calls the constructor FSAPanel(incr, propName, parent).
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSACollapsable (LogicUnparseInterface incr, String propName,
                          JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Overwrites the constructor of FSAPanel.
    *
    * @param incr                 No description provided
    * @param propName             No description provided
    * @param parent               No description provided
    * @param transientProperties  No description provided
    */
   public FSACollapsable (LogicUnparseInterface incr,
                          String propName, JComponent parent, boolean transientProperties)
   {
      super (incr, propName, parent, transientProperties);
   }


   /**
    * creates a standard JPanel with frame for this FSAFrame UMLMethod: '+
    * createJComponent () : Void'
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JCollapsable panel = new JCollapsable();
      panel.addPropertyChangeListener ("collapsed",
         new PropertyChangeListener()
         {
            public void propertyChange (PropertyChangeEvent evt)
            {
               if (!isTransientProperties())
               {
                  addUnparseInformation (COLLAPSED,  ((Boolean) evt.getNewValue()).toString());
               }
            }
         });
      panel.setBackground (FSAObject.COLOR_BACKGROUND);
      panel.setForeground (FSAObject.COLOR_FOREGROUND);
      return  (panel);
   }


   /**
    * Returns true if its inner collapsable panel is collapsed.
    *
    * @return   The collapsed value
    */
   public boolean isCollapsed()
   {
      JCollapsable panel = (JCollapsable) getJComponent();
      return panel.isCollapsed();
   }


   /**
    * Sets the collapse status of its inner component.
    *
    * @param collapsed  The new collapsed value
    */
   public void setCollapsed (boolean collapsed)
   {
      JCollapsable panel = (JCollapsable) getJComponent();
      panel.setCollapsed (collapsed);
   }


   /**
    * Sets the layoutComparator attribute of the FSACollapsable object
    *
    * @param comp  The new layoutComparator value
    */
   public void setLayoutComparator (Comparator comp)
   {
      JCollapsable panel = (JCollapsable) getJComponent();
      panel.setLayoutComparator (comp);
   }


   /**
    * Get the layoutComparator attribute of the FSACollapsable object
    *
    * @return   The layoutComparator value
    */
   public Comparator getLayoutComparator()
   {
      JCollapsable panel = (JCollapsable) getJComponent();
      return panel.getLayoutComparator();
   }


   /**
    * If there is collapsed information saved in unparse information
    * use that, else use default collapse-state.
    */
   protected void applyProperties()
   {
      super.applyProperties();
      boolean collapse = false;

      String collapsedS = getUnparseInformation (COLLAPSED);
      if (collapsedS != null)
      {
         collapse = Boolean.valueOf (collapsedS).booleanValue();
      }
      else
      {
         if (getLogic() instanceof FClass)
         {
            LayoutPreferences preferences = LayoutPreferences.get();
            collapse = preferences.isCollapseClasses();
         }
      }

      setCollapsed (collapse);
   }


   /**
    * This methods sets the default properties for new FSAObjects.
    */
   protected void setDefaultProperties()
   {
      setCollapsed (LayoutPreferences.get().isCollapseClasses());
      saveCollapsed();
      super.setDefaultProperties();
   }


   /**
    * Saves the following additional properties:
    *   collapsed:boolean
    */
   protected void saveAdditionalFSAProperties()
   {
      saveCollapsed();
   }


   /**
    * Saves the 'collapsed' information of this FSACollapsable object.
    */
   public void saveCollapsed()
   {
      addUnparseInformation (COLLAPSED, Boolean.toString (isCollapsed()));
   }

}

/*
 * $Log: FSACollapsable.java,v $
 * Revision 1.27.2.3  2005/11/14 21:55:19  lowende
 * The collapsed property of classes is now loaded correctly again
 * and(!) the preferences options for collapsing classes works for new (especially parsed) classes now.
 *
 */
