/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JCircle;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * UMLClass: 'FSACircle'
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class FSACircle extends FSAObject
{
   /**
    * Constructor for class FSACircle
    *
    * @param incr  No description provided
    */
   public FSACircle (LogicUnparseInterface incr)
   {
      super (incr, null, null);
   }


   /**
    * Constructor for class FSACircle
    *
    * @param incr      No description provided
    * @param property  No description provided
    * @param parent    No description provided
    */
   public FSACircle (LogicUnparseInterface incr, String property, JComponent parent)
   {
      super (incr, property, parent);
   }


   /**
    * Constructor for class FSACircle
    *
    * @param incr    No description provided
    * @param parent  No description provided
    */
   public FSACircle (LogicUnparseInterface incr, JComponent parent)
   {
      this (incr, (String) null, parent);
   }


   /**
    * Constructor for class FSACircle
    *
    * @param incr      No description provided
    * @param property  No description provided
    * @param parent    No description provided
    * @param comp      No description provided
    */
   public FSACircle (LogicUnparseInterface incr, String property, JComponent parent, JComponent comp)
   {
      super (incr, property, parent, comp);
   }


   /**
    * Constructor for class FSACircle
    *
    * @param incr    No description provided
    * @param parent  No description provided
    * @param comp    No description provided
    */
   public FSACircle (LogicUnparseInterface incr, JComponent parent, JComponent comp)
   {
      this (incr, null, parent, comp);
   }


   /**
    * creates a standard JPanel with frame for this FSAFrame UMLMethod: '+ createJComponent
    * () : Void'
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JCircle circle = new JCircle (15);
      circle.setBackground (FSAObject.COLOR_BACKGROUND);
      circle.setForeground (FSAObject.COLOR_FOREGROUND);
      circle.setOpaque (false);
      return  (circle);
   }


   /**
    * update the jComponent to reflect this value UMLMethod: '+ setJComponentValue (value :
    * Object) : Void'
    *
    * @param value  The new jComponentValue value
    */
   public void setJComponentValue (Object value)
   { // FSAObject

      JCircle circle = (JCircle) getJComponent();

      circle.setRadius ( ((Integer) value).intValue());
   }


   /**
    * get the value that is currently visualised by the jComponent UMLMethod: '+ getJComponentValue
    * () : Object'
    *
    * @return   The jComponentValue value
    */
   public Object getJComponentValue()
   { // FSAObject

      JCircle circle = (JCircle) getJComponent();

      return new Integer (circle.getRadius());
   }

}

/*
 * $Log: FSACircle.java,v $
 * Revision 1.15  2004/11/03 10:17:51  lowende
 * Javadoc warnings removed.
 *
 */
