/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.border.Border;

import de.uni_paderborn.fujaba.fsa.swing.border.*;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;


/**
 * Class FSABorderFactory
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.16.2.1 $
 */
public class FSABorderFactory
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FSABorderFactory theInstance = null;


   /**
    * Default Constructor
    */
   private FSABorderFactory() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static FSABorderFactory get()
   {
      if (theInstance == null)
      {
         theInstance = new FSABorderFactory();
      }

      return theInstance;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextBorder createBorder = new TextBorder (ColorsPreferences.get().CREATION, '\u00AB' + "create" + '\u00BB');


   /**
    * Get the createBorder attribute of the FSABorderFactory object
    *
    * @return   The createBorder value
    */
   public TextBorder getCreateBorder()
   {
      return createBorder;
   }


   /**
    * Sets the createBorder attribute of the FSABorderFactory object
    *
    * @param newCreateBorder  The new createBorder value
    */
   public void setCreateBorder (TextBorder newCreateBorder)
   {
      if (createBorder != newCreateBorder)
      {
         createBorder = newCreateBorder;
      }
   }


   /**
    * UMLAttribute : 'deleteBorder : TextBorder '
    */
   private TextBorder deleteBorder = new TextBorder (ColorsPreferences.get().DELETION, '\u00AB' + "destroy" + '\u00BB');


   /**
    * Get the value of deleteBorder.
    *
    * @return   Value of deleteBorder.
    */
   public TextBorder getDeleteBorder()
   {
      return deleteBorder;
   }


   /**
    * Set the value of deleteBorder.
    *
    * @param newDeleteBorder  The new deleteBorder value
    */
   public void setDeleteBorder (TextBorder newDeleteBorder)
   {
      if (deleteBorder != newDeleteBorder)
      {
         deleteBorder = newDeleteBorder;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private LineBorder blackLineBorder = new LineBorder (ColorsPreferences.get().DEFAULT_BORDER);


   /**
    * Get the value of blackLineBorder.
    *
    * @return   Value of blackLineBorder.
    */
   public LineBorder getBlackLineBorder()
   {
      return blackLineBorder;
   }


   /**
    * Set the value of blackLineBorder.
    *
    * @param newBlackLineBorder  The new blackLineBorder value
    */
   public void setBlackLineBorder (LineBorder newBlackLineBorder)
   {
      if (blackLineBorder != newBlackLineBorder)
      {
         blackLineBorder = newBlackLineBorder;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private LineBorder blueLineBorder = new LineBorder (ColorsPreferences.get().SELECTED_BORDER);


   /**
    * Get the value of blueLineBorder.
    *
    * @return   Value of blueLineBorder.
    */
   public LineBorder getBlueLineBorder()
   {
      return blueLineBorder;
   }


   /**
    * Set the value of blueLineBorder.
    *
    * @param newBlueLineBorder  The new blueLineBorder value
    */
   public void setBlueLineBorder (LineBorder newBlueLineBorder)
   {
      if (blueLineBorder != newBlueLineBorder)
      {
         blueLineBorder = newBlueLineBorder;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private LineBorder createLineBorder = new LineBorder (ColorsPreferences.get().CREATION);


   /**
    * Get the createLineBorder attribute of the FSABorderFactory object
    *
    * @return   The createLineBorder value
    */
   public LineBorder getCreateLineBorder()
   {
      return createLineBorder;
   }


   /**
    * Sets the createLineBorder attribute of the FSABorderFactory object
    *
    * @param newCreateLineBorder  The new createLineBorder value
    */
   public void setCreateLineBorder (LineBorder newCreateLineBorder)
   {
      if (createLineBorder != newCreateLineBorder)
      {
         createLineBorder = newCreateLineBorder;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DashedBorder createOptionalBorder = new DashedBorder (ColorsPreferences.get().CREATION);


   /**
    * Get the createOptionalBorder attribute of the FSABorderFactory object
    *
    * @return   The createOptionalBorder value
    */
   public DashedBorder getCreateOptionalBorder()
   {
      return createOptionalBorder;
   }


   /**
    * Sets the createOptionalBorder attribute of the FSABorderFactory object
    *
    * @param newBorder  The new createOptionalBorder value
    */
   public void setCreateOptionalBorder (DashedBorder newBorder)
   {
      createOptionalBorder = newBorder;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private LineBorder deleteLineBorder = new LineBorder (ColorsPreferences.get().DELETION);


   /**
    * Get the deleteLineBorder attribute of the FSABorderFactory object
    *
    * @return   The deleteLineBorder value
    */
   public LineBorder getDeleteLineBorder()
   {
      return deleteLineBorder;
   }


   /**
    * Sets the deleteLineBorder attribute of the FSABorderFactory object
    *
    * @param newDeleteLineBorder  The new deleteLineBorder value
    */
   public void setDeleteLineBorder (LineBorder newDeleteLineBorder)
   {
      if (deleteLineBorder != newDeleteLineBorder)
      {
         deleteLineBorder = newDeleteLineBorder;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DashedBorder dashedLineBorder = new DashedBorder (ColorsPreferences.get().OPTIONAL);


   /**
    * Get the value of dashedLineBorder.
    *
    * @return   Value of dashedLineBorder.
    */
   public DashedBorder getDashedLineBorder()
   {
      return dashedLineBorder;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private SetBorder setBorder = new SetBorder (ColorsPreferences.get().OPTIONAL);


   /**
    * Get the value of setBorder.
    *
    * @return   Value of setBorder.
    */
   public SetBorder getSetBorder()
   {
      return setBorder;
   }


   /**
    * Get the normalBorder attribute of the FSABorderFactory object
    *
    * @return   The normalBorder value
    */
   public Border getNormalBorder()
   {
      return getBlackLineBorder();
   }


   /**
    * Get the selectedBorder attribute of the FSABorderFactory object
    *
    * @return   The selectedBorder value
    */
   public Border getSelectedBorder()
   {
      return getBlueLineBorder();
   }


   /**
    * Get the optionalBorder attribute of the FSABorderFactory object
    *
    * @return   The optionalBorder value
    */
   public Border getOptionalBorder()
   {
      return getDashedLineBorder();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DashedBorder deleteOptionalBorder = new DashedBorder (ColorsPreferences.get().DELETION);


   /**
    * Get the deleteOptionalBorder attribute of the FSABorderFactory object
    *
    * @return   The deleteOptionalBorder value
    */
   public DashedBorder getDeleteOptionalBorder()
   {
      return deleteOptionalBorder;
   }


   /**
    * Sets the deleteOptionalBorder attribute of the FSABorderFactory object
    *
    * @param newBorder  The new deleteOptionalBorder value
    */
   public void setDeleteOptionalBorder (DashedBorder newBorder)
   {
      deleteOptionalBorder = newBorder;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private SetBorder deleteSetBorder = new SetBorder (ColorsPreferences.get().DELETION);


   /**
    * Get the deleteSetBorder attribute of the FSABorderFactory object
    *
    * @return   The deleteSetBorder value
    */
   public SetBorder getDeleteSetBorder()
   {
      return deleteSetBorder;
   }


   /**
    * Sets the deleteSetBorder attribute of the FSABorderFactory object
    *
    * @param newBorder  The new deleteSetBorder value
    */
   public void setDeleteSetBorder (SetBorder newBorder)
   {
      deleteSetBorder = newBorder;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "FSABorderFactory[]";
   }

}

/*
 * $Log: FSABorderFactory.java,v $
 * Revision 1.16.2.1  2006/02/16 09:23:40  creckord
 * Optional Create enabled in GUI and Unparser
 *
 */
