/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * FSABendLine: FSAObject for JBendlines</p> JBendLine is a Line with Bends attached to both
 * ends, that handle the position of start- and endpoint of the line
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.16.2.2 $
 * @see       de.uni_paderborn.fujaba.fsa.swing.JBendLine
 */
public class FSABendLine
    extends FSALine
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String BEND_LOCATION = "bendLocation_";


   /**
    * Constructor for class FSABendLine
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSABendLine (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
   }


   /**
    * Constructor for class FSABendLine
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSABendLine (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Constructor for class FSABendLine
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    * @param comp      No description provided
    */
   public FSABendLine (LogicUnparseInterface incr, String propName, JComponent parent, JComponent comp)
   {
      super (incr, propName, parent, comp);
   }


   /**
    * create empty JBendLine
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      // create empty JBendLine
      JBendLine line = new JBendLine (new Point (0, 0), new Point (0, 0));
      line.setBackground (FSAObject.COLOR_BACKGROUND);
      line.setForeground (FSAObject.COLOR_FOREGROUND);
      return  (line);
   }


   /**
    * Sets the startBend attribute of the FSABendLine object
    *
    * @param bend  The new startBend value
    */
   public void setStartBend (FSABend bend)
   {
      if (bend != null)
      {
         setStartBend ((JBend) bend.getJComponent());
      }
      else
      {
         setStartBend ((JBend) null);
      }
   }


   /**
    * Sets the startBend attribute of the FSABendLine object
    *
    * @param bend  The new startBend value
    */
   public void setStartBend (JBend bend)
   {
       ((JBendLine) getJComponent()).setStartBend (bend);
   }


   /**
    * Get the startBend attribute of the FSABendLine object
    *
    * @return   The startBend value
    */
   public FSABend getStartBend()
   {
      JBendLine line = (JBendLine) getJComponent();

      if (line == null)
      {
         return null;
      }

      JBend bend = line.getStartBend();
      if (bend == null)
      {
         return null;
      }

      return (FSABend) getFSAObjectFromJComponent (bend);
   }


   /**
    * Sets the endBend attribute of the FSABendLine object
    *
    * @param bend  The new endBend value
    */
   public void setEndBend (FSABend bend)
   {
      if (bend != null)
      {
         setEndBend ((JBend) bend.getJComponent());
      }
      else
      {
         setEndBend ((JBend) null);
      }
   }


   /**
    * Sets the endBend attribute of the FSABendLine object
    *
    * @param bend  The new endBend value
    */
   public void setEndBend (JBend bend)
   {
       ((JBendLine) getJComponent()).setEndBend (bend);
   }


   /**
    * Get the endBend attribute of the FSABendLine object
    *
    * @return   The endBend value
    */
   public FSABend getEndBend()
   {
      JBendLine line = (JBendLine) getJComponent();

      if (line == null)
      {
         return null;
      }

      JBend bend = line.getEndBend();
      if (bend == null)
      {
         return null;
      }

      return (FSABend) getFSAObjectFromJComponent (bend);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      JBendLine line = (JBendLine) getJComponent();

      if (line != null)
      {
         JBend bend = line.getStartBend();
         FSABend fsaBend = (FSABend) FSAObject.getFSAObjectFromJComponent (bend);
         if (fsaBend != null)
         {
            fsaBend.removeYou();
         }

         if (bend != null &&
            bend.getParent() != null)
         {
            bend.getParent().remove (bend);
         }

         bend = line.getEndBend();

         fsaBend = (FSABend) FSAObject.getFSAObjectFromJComponent (bend);
         if (fsaBend != null)
         {
            fsaBend.removeYou();
         }

         if (bend != null &&
            bend.getParent() != null)
         {
            bend.getParent().remove (bend);
         }
      }
      super.removeYou();
   }


   /**
    * load formerly saved location of start- and end-bend
    */
   protected void applyProperties()
   {
      super.applyProperties();

      // let start- and end-bend load their location
      FSABend startBend = getStartBend();
      FSABend endBend = getEndBend();

      if (startBend != null)
      {
         startBend.applyProperties();
      }
      if (endBend != null)
      {
         endBend.applyProperties();
      }
   }


   /**
    * Saves location of start- and end-bend.
    */
   public void saveLocation()
   {
      // do not save location of bend-line itself...
      // instead save location of start- and end-bend
      //super.saveLocation();

      // let start- and end-bend save their location
      FSABend startBend = getStartBend();
      FSABend endBend = getEndBend();

      if (startBend != null)
      {
         startBend.saveLocation();
      }
      if (endBend != null)
      {
         endBend.saveLocation();
      }
   }
}

/*
 * $Log: FSABendLine.java,v $
 * Revision 1.16.2.2  2005/05/30 15:11:35  fklar
 * + location of bendline won't be saved... only location of start- and end-bend will be saved
 *
 */
