/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.swing.JArrow;
import de.uni_paderborn.fujaba.fsa.swing.JDirectionIndicator;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * UMLClass: 'FSACircle'
 *
 * @author       $Author: mksoft $
 * @version      $Revision: 1.15.2.1 $
 * @deprecated   Use FSADirectionIndicator, FSADoubleArrow ir FSABigArrow
 */
public class FSAArrow extends FSAObject
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (FSAArrow.class);


   /**
    * Constructor for class FSAArrow
    *
    * @param incr  No description provided
    */
   public FSAArrow (LogicUnparseInterface incr)
   {
      super (incr, null, null);
   }


   /**
    * Constructor for class FSAArrow
    *
    * @param incr          No description provided
    * @param parent        No description provided
    * @param propertyName  No description provided
    */
   public FSAArrow (LogicUnparseInterface incr, String propertyName, JComponent parent)
   {
      super (incr, propertyName, parent);
   }


   /**
    * creates a standard JPanel with frame for this FSAFrame UMLMethod: '+ createJComponent
    * () : Void'
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JArrow arrow = new JArrow();
      arrow.setBackground (FSAObject.COLOR_BACKGROUND);
      arrow.setForeground (FSAObject.COLOR_FOREGROUND);
      return  (arrow);
   }


   /**
    * update the jComponent to reflect this value UMLMethod: '+ setJComponentValue (value :
    * Object) : Void'
    *
    * @param value  The new jComponentValue value
    */
   public void setJComponentValue (Object value) { }


   /**
    * get the value that is currently visualised by the jComponent UMLMethod: '+ getJComponentValue
    * () : Object'
    *
    * @return   The jComponentValue value
    */
   public Object getJComponentValue()
   { // FSAObject

      return null;
   }


   /**
    * Sets the target attribute of the FSAArrow object
    *
    * @param target  The new target value
    */
   public void setTarget (FSAObject target)
   {
      JArrow arrow = (JArrow) getJComponent();
      if (arrow != null)
      {
         if (target != null)
         {
            arrow.setTarget (target.getJComponent());
         }
         else
         {
            arrow.setTarget (null);
         }
      }
   }


   /**
    * Get the target attribute of the FSAArrow object
    *
    * @return   The target value
    */
   public FSAObject getTarget()
   {
      return FSAObject.getFSAObjectFromJComponent ( ((JDirectionIndicator) getJComponent()).getTarget());
   }


   /**
    * Sets the source attribute of the FSAArrow object
    *
    * @param source  The new source value
    */
   public void setSource (FSAObject source)
   {
      JArrow arrow = (JArrow) getJComponent();
      if (arrow != null)
      {
         if (source != null)
         {
            arrow.setSource (source.getJComponent());
         }
         else
         {
            arrow.setSource (null);
         }
      }
   }


   /**
    * Get the source attribute of the FSAArrow object
    *
    * @return   The source value
    */
   public FSAObject getSource()
   {
      return FSAObject.getFSAObjectFromJComponent ( ((JDirectionIndicator) getJComponent()).getSource());
   }


   /**
    * Set the shape of the arrow
    *
    * @param doubleArrow  The new doubleArrow value
    */
   public void setDoubleArrow (boolean doubleArrow)
   {
      if (log.isInfoEnabled())
      {
         log.info ("Executing FSAArrow.setDoubleArrow.");
      }
      JArrow arrow = (JArrow) getJComponent();
      if (arrow != null && doubleArrow != arrow.isDoubleArrow())
      {
         arrow.setDoubleArrow (doubleArrow);
      }
   }


   /**
    * Get the shape of the arrow
    *
    * @return   True if double arrow
    */
   public boolean isDoubleArrow()
   {
      if (log.isInfoEnabled())
      {
         log.info ("Executing FSAArrow.isDoubleArrow.");
      }
      JArrow arrow = (JArrow) getJComponent();
      if (arrow != null)
      {
         return arrow.isDoubleArrow();
      }

      return false;
   }

}

/*
 * $Log: FSAArrow.java,v $
 * Revision 1.15.2.1  2005/09/30 18:57:05  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
