/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.*;

import de.tu_bs.coobra.LocalRepository;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.basic.FileHistory;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.util.ExtensionFileFilter;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.userinterface.UserInterfaceManager;


/**
 * Store all changes in the Repository
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.17.2.1 $
 */
public class StoreAction extends AbstractAction
{
   /**
    * For choosing the filename to store to
    */
   JFileChooser clientChooser;
   /**
    * For choosing the filename to store a server to
    */
   JFileChooser serverChooser;


   /**
    * Perform the action
    *
    * @param event  the ActionEvent for performing the action
    */
   public void actionPerformed (ActionEvent event)
   {
      //new SaveProjectAsAction().actionPerformed( event );
      LocalRepository repo = FujabaChangeManager.getVMRepository();
      if (repo != null)
      {
         //ask where to save
         JFileChooser chooser;
         String extension;

         if (repo.isServerRepository())
         {
            //server
            extension = "cxsr";
            if (serverChooser == null)
            {
               serverChooser = new JFileChooser (".");
               ExtensionFileFilter filter = new ExtensionFileFilter();
               filter.addExtension (extension);
               filter.addExtension (extension + ".gz");
               filter.setDescription ("CoObRA XML Server Repository");
               serverChooser.setFileFilter (filter);
            }
            chooser = serverChooser;
         }
         else
         {
            //client
            extension = "cxr";
            if (clientChooser == null)
            {
               clientChooser = new JFileChooser (".");
               ExtensionFileFilter filter = new ExtensionFileFilter();
               filter.addExtension (extension);
               filter.addExtension (extension + ".gz");
               filter.setDescription ("CoObRA XML Repository");
               clientChooser.setFileFilter (filter);
            }
            chooser = clientChooser;
         }

         int result = chooser.showSaveDialog (FrameMain.get());

         if (result == JFileChooser.APPROVE_OPTION)
         {
            String filename = chooser.getSelectedFile().getPath();
            if (filename != null &&  (filename.length() > 0))
            {
               boolean zip = true;
               if (filename.lastIndexOf ('.') <= filename.lastIndexOf (File.separatorChar))
               {
                  filename += "." + extension + ".gz";
               }
               else if (filename.toLowerCase().endsWith ("." + extension))
               {
                  zip = false;
               }

               try
               {
                  repo.store (filename, zip);
                  FileHistory.get().addToHistory (new File (filename));
                  UMLProject.get().setSaved (true);
                  UMLProject.get().setFile (new File (filename));
                  FrameMain.get().setSaveAction (UserInterfaceManager.get().getFromActions ("coobra.store"));
               }
               catch (IOException e)
               {
                  JOptionPane.showMessageDialog (FrameMain.get(), "Failed to store changes: " + e.getMessage(), "Store changes", JOptionPane.ERROR_MESSAGE);
               }
            }
         }
      }
   }
}

/*
 * $Log: StoreAction.java,v $
 * Revision 1.17.2.1  2006/04/12 10:20:44  cschneid
 * set file and save action on coobra save
 *
 */
