/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.*;
import java.awt.event.*;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.tu_bs.coobra.remote.lightweight.LightWeightNameService;
import de.tu_bs.coobra.remote.lightweight.LightWeightServerImpl;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;


/**
 * @author    $Author: lowende $
 * @version   $Revision: 1.22 $
 */
public class SelectServerRepositoryDialog extends javax.swing.JDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String NAME_SERVER = "name server";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String NAME_SERVER_PORT = "name server port";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean nameServerChecked = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String REPOSITORY_HOST = "repository host";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String REPOSITORY_PORT = "repository port";


   /**
    * Creates new form SelectServerRepositoryDialog
    *
    * @param owner  the <code>Frame</code> from which the dialog is displayed
    * @param modal  true for a modal dialog, false for one that allows others windows to be
    *      active at the same time
    */
   public SelectServerRepositoryDialog (Frame owner, boolean modal)
   {
      super (owner, modal);
      initComponents();
      //center the frame
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension frameSize = this.getSize();
      if (frameSize.height > screenSize.height)
      {
         frameSize.height = screenSize.height;
      }
      if (frameSize.width > screenSize.width)
      {
         frameSize.width = screenSize.width;
      }
      this.setLocation ( (screenSize.width - frameSize.width) / 2,  (screenSize.height - frameSize.height) / 2);
   }


   /**
    * data for JList (history)
    */
   private Vector historyListData;


   /**
    * Get the nameServerChecked attribute of the SelectServerRepositoryDialog object
    *
    * @return   The nameServerChecked value
    */
   public boolean isNameServerChecked()
   {
      return nameServerChecked;
   }


   /**
    * Sets the nameServerChecked attribute of the SelectServerRepositoryDialog object
    *
    * @param nameServerChecked  The new nameServerChecked value
    */
   public void setNameServerChecked (boolean nameServerChecked)
   {
      int port;
      try
      {
         port = Integer.parseInt (nameServerPort.getText());
      }
      catch (NumberFormatException e)
      {
         port = 0;
      }
      this.nameServerChecked = nameServerChecked;
      if (nameServerChecked)
      {
         nameServerBox.setSelectedItem (NAME_SERVER);
         portLabel.setText (NAME_SERVER_PORT);
         repositoryName.setEnabled (true);

         if (lightweightCheck.isSelected())
         {
            if (port >= LightWeightServerImpl.DEFAULT_PORT_RANGE_START &&  (port - LightWeightServerImpl.DEFAULT_PORT_RANGE_START) < LightWeightServerImpl.DEFAULT_PORT_RANGE_LENGTH)
            {
               nameServerPort.setText (String.valueOf (LightWeightNameService.DEFAULT_PORT));
            }
         }
      }
      else
      {
         nameServerBox.setSelectedItem (REPOSITORY_HOST);
         portLabel.setText (REPOSITORY_PORT);
         repositoryName.setEnabled (false);
         if (lightweightCheck.isSelected())
         {
            if (port == LightWeightNameService.DEFAULT_PORT)
            {
               nameServerPort.setText (String.valueOf (LightWeightServerImpl.DEFAULT_PORT_RANGE_START));
            }
         }
      }
   }


   /**
    * This method is called from within the constructor to initialize the form. WARNING: Do
    * NOT modify this code. The content of this method is always regenerated by the Form Editor.
    */
   private void initComponents()
   { //GEN-BEGIN:initComponents

      jTabbedPane = new javax.swing.JTabbedPane();
      jPanel1 = new javax.swing.JPanel();
      nameTabLabelPanel = new javax.swing.JPanel();
      nameTabLeftPanel = new javax.swing.JPanel();
      nameServerBox = new javax.swing.JComboBox();
      portLabel = new javax.swing.JLabel();
      repositoryNameLabel = new javax.swing.JLabel();
      loginLabel = new javax.swing.JLabel();
      passwordLabel = new javax.swing.JLabel();
      connectOnlyLabel = new javax.swing.JLabel();
      connectOnly = new javax.swing.JCheckBox();
      lightweightLabel = new javax.swing.JLabel();
      nameTabContentPanel = new javax.swing.JPanel();
      nameServer = new javax.swing.JTextField();
      nameServerPort = new javax.swing.JTextField();
      repositoryName = new javax.swing.JTextField();
      login = new javax.swing.JTextField();
      password = new javax.swing.JPasswordField();
      lightweightCheck = new JCheckBox();
      jPanel7 = new javax.swing.JPanel();
      jPanel2 = new javax.swing.JPanel();
      iorTabLabelPanel = new javax.swing.JPanel();
      iorLabel = new javax.swing.JLabel();
      jPanel6 = new javax.swing.JPanel();
      ior = new javax.swing.JTextField();
      jPanel8 = new javax.swing.JPanel();
      okButton = new javax.swing.JButton();
      cancelButton = new javax.swing.JButton();
      historyPanel = new JPanel();
      historyListData = new Vector();
      historyList = new JList (historyListData);
      historyDeleteButton = new JButton();

      addWindowListener (
         new java.awt.event.WindowAdapter()
         {
            public void windowClosing (java.awt.event.WindowEvent evt)
            {
               closeDialog (evt);
            }
         });

      jPanel1.setLayout (new BorderLayout());

      jPanel1.setBorder (new javax.swing.border.EmptyBorder (new Insets (3, 3, 3, 3)));
      nameTabLabelPanel.setLayout (new GridLayout (0, 1));
      nameServerBox.addItem (NAME_SERVER);
      nameServerBox.addItem (REPOSITORY_HOST);
      setNameServerChecked (true);
      nameServerBox.setSelectedItem ("");

      nameServerBox.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               setNameServerChecked (NAME_SERVER.equals (nameServerBox.getSelectedItem()));
            }
         });
      nameTabLabelPanel.add (nameServerBox);

      nameTabLabelPanel.add (portLabel);

      repositoryNameLabel.setText ("repository name");
      nameTabLabelPanel.add (repositoryNameLabel);

      lightweightLabel.setText ("lightweight");
      nameTabLabelPanel.add (lightweightLabel);

      loginLabel.setText ("user name");
      nameTabLabelPanel.add (loginLabel);

      passwordLabel.setText ("password");
      nameTabLabelPanel.add (passwordLabel);

      connectOnlyLabel.setText ("connect only");
      nameTabLabelPanel.add (connectOnlyLabel);

      nameTabLeftPanel.setLayout (new BorderLayout());
      nameTabLeftPanel.add (nameTabLabelPanel, BorderLayout.WEST);
      JPanel nameTabLeftPanelSurround = new JPanel();
      nameTabLeftPanelSurround.setLayout (new BorderLayout());
      nameTabLeftPanelSurround.add (nameTabLeftPanel, BorderLayout.NORTH);
      jPanel1.add (nameTabLeftPanelSurround, BorderLayout.WEST);

      nameTabContentPanel.setLayout (new GridLayout (0, 1));

      nameTabContentPanel.setBorder (new javax.swing.border.EmptyBorder (new Insets (0, 5, 0, 0)));
      nameServer.setText ("www.se.eecs.uni-kassel.de");
      nameTabContentPanel.add (nameServer);

      nameServerPort.setText ("1900");
      nameTabContentPanel.add (nameServerPort);

      repositoryName.setText ("ServerRepository");
      nameTabContentPanel.add (repositoryName);

      lightweightCheck.setSelected (true);
      nameTabContentPanel.add (lightweightCheck);

      login.setText ("guest");
      nameTabContentPanel.add (login);

      password.setText ("guest");
      nameTabContentPanel.add (password);

      connectOnly.setSelected (false);
      nameTabContentPanel.add (connectOnly);

      historyPanel.setLayout (new BorderLayout());
      JPanel spacer = new JPanel();
      spacer.setPreferredSize (new Dimension (5, 5));
      historyPanel.add (spacer, BorderLayout.WEST);
      JPanel historyContentPanel = new JPanel();
      historyContentPanel.setLayout (new BorderLayout());
      historyContentPanel.add (new JScrollPane (historyList), BorderLayout.CENTER);
      historyDeleteButton.setText ("delete entry");
      historyContentPanel.add (historyDeleteButton, BorderLayout.SOUTH);
      historyPanel.add (historyContentPanel, BorderLayout.CENTER);

      historyDeleteButton.addActionListener (
         new java.awt.event.ActionListener()
         {
            public void actionPerformed (java.awt.event.ActionEvent evt)
            {
               historyDeleteButtonActionPerformed (evt);
            }
         });

      historyList.addListSelectionListener (
         new ListSelectionListener()
         {
            /**
             * Called whenever the value of the selection changes.
             *
             * @param e  the event that characterizes the change.
             */
            public void valueChanged (ListSelectionEvent e)
            {
               listEntrySelected();
            }
         });

      historyList.addMouseListener (
         new MouseAdapter()
         {
            /**
             * Invoked when the mouse has been clicked on a component.
             *
             * @param e  No description provided
             */
            public void mouseClicked (MouseEvent e)
            {
               listEntrySelected();
            }
         });

      nameTabLeftPanel.add (nameTabContentPanel, BorderLayout.CENTER);

      jPanel1.add (jPanel7, BorderLayout.SOUTH);
      jPanel1.add (historyPanel, BorderLayout.EAST);

      jTabbedPane.addTab ("by name", jPanel1);

      jPanel2.setLayout (new BorderLayout());

      jPanel2.setBorder (new javax.swing.border.EmptyBorder (new Insets (3, 3, 3, 3)));
      iorTabLabelPanel.setLayout (new BorderLayout());

      iorTabLabelPanel.setBorder (new javax.swing.border.EmptyBorder (new Insets (3, 0, 0, 0)));
      iorLabel.setText ("IOR of server repository");
      iorLabel.setMaximumSize (new Dimension (117, 22));
      iorLabel.setMinimumSize (new Dimension (117, 22));
      iorTabLabelPanel.add (iorLabel, BorderLayout.NORTH);

      jPanel2.add (iorTabLabelPanel, BorderLayout.WEST);

      jPanel6.setLayout (new BorderLayout());

      jPanel6.setBorder (new javax.swing.border.EmptyBorder (new Insets (0, 5, 0, 0)));
      jPanel6.add (ior, BorderLayout.NORTH);

      jPanel2.add (jPanel6, BorderLayout.CENTER);

      jTabbedPane.addTab ("by IOR", jPanel2);

      getContentPane().add (jTabbedPane, BorderLayout.CENTER);

      okButton.setMnemonic ('O');
      okButton.setText ("OK");
      okButton.addActionListener (
         new java.awt.event.ActionListener()
         {
            public void actionPerformed (java.awt.event.ActionEvent evt)
            {
               okButtonActionPerformed (evt);
            }
         });

      jPanel8.add (okButton);

      cancelButton.setMnemonic ('C');
      cancelButton.setText ("Cancel");
      cancelButton.addActionListener (
         new java.awt.event.ActionListener()
         {
            public void actionPerformed (java.awt.event.ActionEvent evt)
            {
               jButton2ActionPerformed (evt);
            }
         });

      jPanel8.add (cancelButton);

      getContentPane().add (jPanel8, BorderLayout.SOUTH);

      okButton.getRootPane().setDefaultButton (okButton);
      loadHistory();

      pack();
   } //GEN-END:initComponents


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   void listEntrySelected()
   {
      if (historyList.getSelectedValue() != null)
      {
         HistoryEntry entry = (HistoryEntry) historyList.getSelectedValue();
         nameServer.setText (entry.getNameServer());
         nameServerPort.setText (entry.getNameServerPort());
         setNameServerChecked (entry.isUsingNameServer());
         repositoryName.setText (entry.getRepository());
         login.setText (entry.getLogin());
         if ("guest".equals (entry.getLogin()))
         {
            password.setText ("guest");
            password.setSelectionStart (0);
            password.setSelectionEnd ("guest".length());
         }
         else
         {
            password.setText ("");
         }
         password.requestFocus();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param evt  No description provided
    */
   void historyDeleteButtonActionPerformed (ActionEvent evt)
   {
      if (historyList.getSelectedIndex() >= 0)
      {
         historyListData.remove (historyList.getSelectedIndex());
         historyList.updateUI();
      }
   }


   /**
    * jButton2 is pressed
    *
    * @param evt  awt event
    */
   void jButton2ActionPerformed (java.awt.event.ActionEvent evt)
   { //GEN-FIRST:event_jButton2ActionPerformed
      //GEN-HEADEREND:event_jButton2ActionPerformed
      hide();
   } //GEN-LAST:event_jButton2ActionPerformed


   /**
    * when true ok was pressed
    */
   boolean ok = false;


   /**
    * Get the ok attribute of the SelectServerRepositoryDialog object
    *
    * @return   The ok value
    */
   public boolean isOk()
   {
      return ok;
   }


   /**
    * overrides show() to set ok-status to false
    */
   public void show()
   {
      ok = false;
      loadHistory();
      super.show();
   }


   /**
    * key for connect properties
    */
   public final static String PROPERTIES_KEY = "coobra/connect.properties";
   /**
    * key for history data
    */
   public final static String HISTORY_KEY = "history";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.22 $
    */
   private static class HistoryEntry
   {
      /**
       * name server hostname
       */
      private String nameServer;
      /**
       * name server port
       */
      private String nameServerPort;
      /**
       * repository name
       */
      private String repository;
      /**
       * login
       */
      private String login;
      /**
       * true if name server should be used
       */
      private boolean usingNameServer;


      /**
       * @return   login
       */
      public String getLogin()
      {
         return login;
      }


      /**
       * @return   hostname
       */
      public String getNameServer()
      {
         return nameServer;
      }


      /**
       * @return   port number as String
       */
      public String getNameServerPort()
      {
         return nameServerPort;
      }


      /**
       * @return   repository name
       */
      public String getRepository()
      {
         return repository;
      }


      /**
       * @param login            login
       * @param nameServer       name server hostname
       * @param nameServerPort   name server port
       * @param repository       repository name
       * @param usingNameServer  No description provided
       */
      public HistoryEntry (String nameServer, String nameServerPort, String repository, String login, boolean usingNameServer)
      {
         this.nameServer = nameServer;
         this.nameServerPort = nameServerPort;
         this.repository = repository;
         this.login = login;
         this.usingNameServer = usingNameServer;
      }


      /**
       * @param data  fill values from data String obtained from {@link #getData()}
       */
      public HistoryEntry (String data)
      {
         StringTokenizer tokenizer = new StringTokenizer (data, "\n");
         nameServer = tokenizer.nextToken();
         nameServerPort = tokenizer.nextToken();
         repository = tokenizer.nextToken();
         login = tokenizer.nextToken();
         if (tokenizer.hasMoreTokens())
         {
            usingNameServer = Boolean.valueOf (tokenizer.nextToken()).booleanValue();
         }
         else
         {
            usingNameServer = true;
         }
      }


      /**
       * Get the usingNameServer attribute of the HistoryEntry object
       *
       * @return   The usingNameServer value
       */
      public boolean isUsingNameServer()
      {
         return usingNameServer;
      }


      /**
       * @return   a single Strin representing the data of this entry
       */
      public String getData()
      {
         return getNameServer() + "\n" +
            getNameServerPort() + "\n" +
            getRepository() + "\n" +
            getLogin() + "\n" +
            isUsingNameServer();
      }


      /**
       * @return   repository name
       */
      public String toString()
      {
         return isUsingNameServer() ? getRepository() : getNameServer() + ":" + getNameServerPort();
      }


      /**
       * @param o  object to compare to
       * @return   true when all values equal
       */
      public boolean equals (Object o)
      {
         return getData().equals ( ((HistoryEntry) o).getData());
      }
   }


   /**
    * load history vector from properties
    */
   private void loadHistory()
   {

      PreferencesProperties props = PreferencesProperties.get (PROPERTIES_KEY);
      Vector fileNameVector = props.getVectorSetting (HISTORY_KEY);

      //delete old history
      historyListData.clear();

      for (int i = 0; i < fileNameVector.size(); i++)
      {
         HistoryEntry entry = new HistoryEntry ((String) fileNameVector.elementAt (i));
         historyListData.add (entry);
      }
      historyList.updateUI();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void saveHistory()
   {
      PreferencesProperties props = PreferencesProperties.get (PROPERTIES_KEY);
      Vector dataVector = new Vector();

      try
      {
         for (int i = 0; i < historyListData.size(); i++)
         {
            HistoryEntry entry = (HistoryEntry) historyListData.elementAt (i);
            dataVector.add (entry.getData());
         }

         props.putSetting (HISTORY_KEY, dataVector);
         props.save();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }


   /**
    * Get the byName attribute of the SelectServerRepositoryDialog object
    *
    * @return   The byName value
    */
   public boolean isByName()
   {
      return jTabbedPane.getSelectedIndex() == 0;
   }


   /**
    * Get the nameServer attribute of the SelectServerRepositoryDialog object
    *
    * @return   The nameServer value
    */
   public String getNameServer()
   {
      return nameServer.getText().trim();
   }


   /**
    * Get the nameServerPort attribute of the SelectServerRepositoryDialog object
    *
    * @return   The nameServerPort value
    */
   public String getNameServerPort()
   {
      return nameServerPort.getText().trim();
   }


   /**
    * Get the repositoryName attribute of the SelectServerRepositoryDialog object
    *
    * @return   The repositoryName value
    */
   public String getRepositoryName()
   {
      return repositoryName.getText().trim();
   }


   /**
    * Get the login attribute of the SelectServerRepositoryDialog object
    *
    * @return   the user name
    */
   public String getLogin()
   {
      return login.getText().trim();
   }


   /**
    * Get the password attribute of the SelectServerRepositoryDialog object
    *
    * @return   the password
    */
   public String getPassword()
   {
      return new String (password.getPassword()).trim();
   }


   /**
    * Set the login attribute of the SelectServerRepositoryDialog object
    *
    * @param value  new value
    */
   public void setLogin (String value)
   {
      login.setText (value);
   }


   /**
    * Set the repositoryName attribute of the SelectServerRepositoryDialog object
    *
    * @param value  new value
    */
   public void setPassword (String value)
   {
      password.setText (value);
   }


   /**
    * @return   true when the lightweight checkbox is checked
    */
   public boolean isLightweightChecked()
   {
      return lightweightCheck.isSelected();
   }


   /**
    * @return   true when the lightweight checkbox is checked
    */
   public boolean isConnectOnlyChecked()
   {
      return connectOnly.isSelected();
   }


   /**
    * Get the iOR attribute of the SelectServerRepositoryDialog object
    *
    * @return   The iOR value
    */
   public String getIOR()
   {
      return ior.getText().trim();
   }


   /**
    * Sets the iOR attribute of the SelectServerRepositoryDialog object
    *
    * @param text  The new iOR value
    */
   public void setIOR (String text)
   {
      ior.setText (text);
   }


   /**
    * Sets the iOREnabled attribute of the SelectServerRepositoryDialog object
    *
    * @param enabled  The new iOREnabled value
    */
   public void setIOREnabled (boolean enabled)
   {
      ior.setEnabled (enabled);
   }


   /**
    * create a new entry with the current data in the history list
    */
   public void rememberCurrentDataInHistoryList()
   {
      HistoryEntry entry = new HistoryEntry (getNameServer(), getNameServerPort(), getRepositoryName(), getLogin(), isNameServerChecked());
      if (!historyListData.contains (entry))
      {
         historyListData.add (entry);
      }
      saveHistory();
   }


   /**
    * jButton1 was pressed
    *
    * @param evt  awt event
    */
   void okButtonActionPerformed (java.awt.event.ActionEvent evt)
   { //GEN-FIRST:event_jButton1ActionPerformed
      //GEN-HEADEREND:event_jButton1ActionPerformed
      ok = true;
      saveHistory();
      hide();
   } //GEN-LAST:event_jButton1ActionPerformed


   /**
    * Closes the dialog
    *
    * @param evt  awt event
    */
   void closeDialog (java.awt.event.WindowEvent evt)
   { //GEN-FIRST:event_closeDialog
      setVisible (false);
      dispose();
   } //GEN-LAST:event_closeDialog

   // Variables declaration - do not modify//GEN-BEGIN:variables
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel jPanel8;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel jPanel7;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel jPanel6;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel iorTabLabelPanel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel nameTabContentPanel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel nameTabLabelPanel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel nameTabLeftPanel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel jPanel2;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPanel jPanel1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JButton cancelButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JButton okButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JTextField repositoryName;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JTextField login;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JPasswordField password;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox lightweightCheck;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JTextField nameServer;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JTabbedPane jTabbedPane;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JTextField nameServerPort;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JTextField ior;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JLabel iorLabel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JLabel repositoryNameLabel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JLabel loginLabel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JLabel passwordLabel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JLabel connectOnlyLabel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JCheckBox connectOnly;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JLabel lightweightLabel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private javax.swing.JLabel portLabel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   javax.swing.JComboBox nameServerBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel historyPanel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JList historyList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton historyDeleteButton;
   // End of variables declaration//GEN-END:variables
}

/*
 * $Log: SelectServerRepositoryDialog.java,v $
 * Revision 1.22  2005/01/28 11:36:30  lowende
 * Removed some compile warnings.
 *
 */
