/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;


/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.6 $ $Date: 2004/10/20 17:49:40 $
 */
public class ProgressDialog extends JDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JProgressBar progressBar;


   /**
    * create components
    */
   private void init()
   {
      progressBar = new JProgressBar();
      progressBar.setMaximum (100);
      progressBar.setPreferredSize (new Dimension (300, progressBar.getPreferredSize().height));
      JPanel panel = new JPanel();
      panel.setLayout (new BorderLayout());
      panel.add (progressBar);
      panel.setBorder (new EmptyBorder (15, 15, 15, 15));
      getContentPane().add (panel);
      setDefaultCloseOperation (WindowConstants.DO_NOTHING_ON_CLOSE);
      pack();
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension frameSize = this.getSize();
      if (frameSize.height > screenSize.height)
      {
         frameSize.height = screenSize.height;
      }
      if (frameSize.width > screenSize.width)
      {
         frameSize.width = screenSize.width;
      }
      this.setLocation ( (screenSize.width - frameSize.width) / 2,  (screenSize.height - frameSize.height) / 2);
   }


   /**
    * @param owner               owner of this dialog
    * @throws HeadlessException  if super constructor throws HeadlessException
    */
   public ProgressDialog (Frame owner)
       throws HeadlessException
   {
      super (owner, true);
      init();
   }


   /**
    * Sets the percentage attribute of the ProgressDialog object
    *
    * @param percent  The new percentage value
    */
   public void setPercentage (int percent)
   {
      if (percent > 100)
      {
         percent = 100;
      }
      else if (percent < 0)
      {
         percent = 0;
      }
      progressBar.setValue (percent);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Object visibleSignal = new Object();

//   public void setVisible( boolean visible )
//   {
//      super.setVisible( visible );
//
//      if ( !visible )
//      {
//         synchronized( visibleSignal )
//         {
//            visibleSignal.notify();
//         }
//      }
//
//      if ( visible )
//      {
//         FrameMain.get().setEnabled( false );
//         try
//         {
//            try
//            {
//               synchronized( visibleSignal )
//               {
//                  visibleSignal.wait();
//               }
//            } catch ( InterruptedException e )
//            {
//               e.printStackTrace();
//            }
//         } finally
//         {
//            FrameMain.get().setEnabled( true );
//         }
//      }
//   }
}

/*
 * $Log: ProgressDialog.java,v $
 * Revision 1.6  2004/10/20 17:49:40  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
