/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.event.ActionEvent;

import javax.swing.*;

import de.tu_bs.coobra.remote.ClientRepositoryOperations;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.upb.lib.userinterface.ActionExecutionListener;
import de.upb.lib.userinterface.UserInterfaceManager;


/**
 * Toggle automatic update+checkin on/off
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
public class AutoUpdateAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static ActionExecutionListener actionExecutionListener;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static ClientRepositoryOperations checkinListener;


   /**
    * Invoked when an action occurs.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      if (FujabaChangeManager.getVMRepository() != null && FujabaChangeManager.getVMRepository().isConnected())
      {
         int result = JOptionPane.showConfirmDialog (FrameMain.get(),
            "Do want to update your local project automatically when the server has a new version and " +
            "checkin your changes automatically after each action?\n", "Automatic update + checkin",
            JOptionPane.YES_NO_CANCEL_OPTION);
         if (result == JOptionPane.YES_OPTION)
         {
            if (actionExecutionListener == null)
            {
               actionExecutionListener =
                  new ActionExecutionListener()
                  {
                     /**
                      * This method will be called before actionPerformed() is executed.
                      *
                      * @param e  The action-defined event.
                      */
                     public void preActionNotify (ActionEvent e)
                     {
                     }


                     /**
                      * This method will be called after actionPerformed was executed.
                      *
                      * @param e  The action-defined event.
                      */
                     public void postActionNotify (ActionEvent e)
                     {
                        new CheckinAction().actionPerformed (e);
                     }
                  };
            }

            if (checkinListener == null)
            {
               checkinListener =
                  new ClientRepositoryOperations()
                  {
                     /**
                      * Notifies the client that some changes have been checked in.
                      */
                     public void notifyCheckin()
                     {
                        new UpdateAction().actionPerformed (null);
                     }


                     /**
                      * Notifies the client that the client was disconnected
                      */
                     public void notifyDisconnect()
                     {

                     }
                  };
            }

            UserInterfaceManager.get().addExecutionListener (actionExecutionListener);
            //readd to ensure listener is reconnected
            FujabaChangeManager.getVMRepository().getRemoteRepository().removeFromCheckinListeners (checkinListener);
            FujabaChangeManager.getVMRepository().getRemoteRepository().addToCheckinListeners (checkinListener);
         }
         else if (result == JOptionPane.NO_OPTION)
         {
            UserInterfaceManager.get().removeExecutionListener (actionExecutionListener);
            FujabaChangeManager.getVMRepository().getRemoteRepository().removeFromCheckinListeners (checkinListener);
         }
         //else leave it on/off
      }
      else
      {
         FrameMain.get().setStatusLabel ("Not connected to a server!");
      }
   }
}

/*
 * $Log: AutoUpdateAction.java,v $
 * Revision 1.9  2004/10/29 13:46:53  lowende
 * Some improvements for parsed code
 *
 */
