/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen.digester.rules;

import java.util.HashMap;
import org.xml.sax.Attributes;

import de.uni_paderborn.fujaba.codegen.digester.XDigester;


/**
 * Rule implementation that sets an individual property on the object at the top of the stack,
 * based on attributes with specified names.
 *
 * @author    Craig McClanahan
 * @version   $Revision: 1.7 $ $Date: 2004/10/29 13:46:53 $
 */
public class XSetPropertyRule extends XSetPropertiesRule
{
   /**
    * Construct a "set property" rule with the specified name and value attributes.
    *
    * @param digester  The digester with which this rule is associated
    * @param name      Name of the attribute that will contain the name of the property to
    *      be set
    * @param value     Name of the attribute that will contain the value to which the property
    *      should be set
    */
   public XSetPropertyRule (XDigester digester, String name, String value)
   {
      super (digester);
      this.name = name;
      this.value = value;
   }


   /**
    * The attribute that will contain the property name.
    */
   protected String name = null;

   /**
    * The attribute that will contain the property value.
    */
   protected String value = null;


   // --------------------------------------------------------- Public Methods


   /**
    * Process the beginning of this element.
    *
    * @param attributes  The attribute list of this element
    * @throws Exception  Exception description not provided
    */
   public void begin (Attributes attributes) throws Exception
   {

      // Identify the actual property name and value to be used
      String actualName = null;
      String actualValue = null;
      HashMap values = new HashMap();
      for (int i = 0; i < attributes.getLength(); i++)
      {
         String name = attributes.getQName (i);
         String value = attributes.getValue (i);
         if (name.equals (this.name))
         {
            actualName = value;
         }
         else if (name.equals (this.value))
         {
            actualValue = value;
         }
      }
      values.put (actualName, actualValue);

      // Populate the corresponding property of the top object
      Object top = digester.peek();
      if (digester.getDebug() >= 1)
      {
         digester.log ("Set " + top.getClass().getName() + " property " +
            actualName + " to " + actualValue);
      }
      populate (top, values);
      //throw new UnsupportedOperationException (this + ".begin(" + attributes + ")");
   }
}

/*
 * $Log: XSetPropertyRule.java,v $
 * Revision 1.7  2004/10/29 13:46:53  lowende
 * Some improvements for parsed code
 *
 */
