/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen.digester.rules;

import org.xml.sax.Attributes;

import de.uni_paderborn.fujaba.codegen.digester.XDigester;
import de.uni_paderborn.fujaba.codegen.digester.XRule;


/**
 * Rule implementation that saves a parameter from either an attribute of this element, or
 * from the element body, to be used in a call generated by a surrounding CallMethodRule rule.
 *
 * @author    Craig McClanahan
 * @version   $Revision: 1.7 $ $Date: 2004/10/29 13:46:53 $
 */
public class XCallParamRule extends XRule
{
   /**
    * Construct a "call parameter" rule that will save the body text of this element as the
    * parameter value.
    *
    * @param digester    The associated Digester
    * @param paramIndex  The zero-relative parameter number
    */
   public XCallParamRule (XDigester digester, int paramIndex)
   {
      this (digester, paramIndex, null);
   }


   /**
    * Construct a "call parameter" rule that will save the value of the specified attribute
    * as the parameter value.
    *
    * @param digester       The associated Digester
    * @param paramIndex     The zero-relative parameter number
    * @param attributeName  The name of the attribute to save
    */
   public XCallParamRule (XDigester digester, int paramIndex,
                          String attributeName)
   {

      super (digester);
      this.paramIndex = paramIndex;
      this.attributeName = attributeName;

   }


   // ----------------------------------------------------- Instance Variables


   /**
    * The attribute from which to save the parameter value
    */
   protected String attributeName = null;

   /**
    * The body text collected from this element.
    */
   protected String bodyText = null;

   /**
    * The zero-relative index of the parameter we are saving.
    */
   protected int paramIndex = 0;


   // --------------------------------------------------------- Public Methods


   /**
    * Process the start of this element.
    *
    * @param attributes  The attribute list for this element
    * @throws Exception  Exception description not provided
    */
   public void begin (Attributes attributes) throws Exception
   {

      if (attributeName != null)
      {
         bodyText = attributes.getValue (attributeName);
      }

   }


   /**
    * Process the body text of this element.
    *
    * @param bodyText    The body text of this element
    * @throws Exception  Exception description not provided
    */
   public void body (String bodyText) throws Exception
   {

      if (attributeName == null)
      {
         this.bodyText = bodyText.trim();
      }

   }


   /**
    * Process the end of this element.
    *
    * @throws Exception  Exception description not provided
    */
   public void end() throws Exception
   {

      String parameters[] = (String[]) digester.peek();
      parameters[paramIndex] = bodyText;

   }


   /**
    * Clean up after parsing is complete.
    *
    * @throws Exception  Exception description not provided
    */
   public void finish() throws Exception
   {

      attributeName = null;
      bodyText = null;

   }

}

/*
 * $Log: XCallParamRule.java,v $
 * Revision 1.7  2004/10/29 13:46:53  lowende
 * Some improvements for parsed code
 *
 */
