/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import org.apache.log4j.Logger;
import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.*;


/**
 * Class UmlAttrExprPairOOFunction
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.19.2.2 $
 */
public class UmlAttrExprPairOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UmlAttrExprPairOOFunction.class);


   /**
    * Default Constructor
    */
   public UmlAttrExprPairOOFunction() { }


   /**
    * Get the responsible attribute of the UmlAttrExprPairOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.UML_ATTR_EXPR_PAIR.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param param       No description provided
    * @param asgElement  No description provided
    * @return            an <code>OOExpression</code> value
    */
   public final Object generateCode (FElement asgElement, String methodName, Object param[])
   {
      UMLAttrExprPair umlAttrExprPair = (UMLAttrExprPair) asgElement;
      UMLObject umlObject = umlAttrExprPair.getRevAttrs();
      if (umlAttrExprPair.getInstanceOf() == null)
      {
         throw new RuntimeExceptionWithContext ("Attribute assertion/assignment has no associated attribute!", umlAttrExprPair);
      }
      UMLType variableType = umlAttrExprPair.getInstanceOf().getAttrType();
      if (variableType == null)
      {
         throw new RuntimeExceptionWithContext ("Attribute assertion/assignment has no associated attribute type!", umlAttrExprPair);
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".umlAttrExprPair(" + umlAttrExprPair + ")");
      }

      OOExpression theExpression = null;

      boolean isStringType = variableType.getName().equals (UMLBaseTypes.STRING);

      OOVariable objectVar;
      if (umlObject.isSet())
      {
         objectVar = OO.variable (umlObject.getObjectType(), OOVariableType.iFujabaTmpObject);
      }
      else
      {
         objectVar = OO.variable (umlObject.getObjectName());
      }

      OOMethod accessMethod =  (variableType.getName().equals (UMLBaseTypes.BOOLEAN)) ?
         OO.method (umlAttrExprPair.getName(), OOMethodType.IS_METHOD) :
         OO.method (umlAttrExprPair.getName(), OOMethodType.GET_METHOD);

      if (umlAttrExprPair.getOperation() == UMLAttrExprPair.REG_EXPRESSION)
      {
         if (isStringType)
         {
            // it is a regular expression
            OOCallMethodExpr paramMethodExpr = OO.call (objectVar, accessMethod);

            OOCallMethodExpr callMethodExpr = OO.call (OOMethod.CHECK_REG_EXPRESSION);
            callMethodExpr.addToParameter (OO.identifier (umlAttrExprPair.getExpression()));
            callMethodExpr.addToParameter (paramMethodExpr);

            OOExpression preExpr = OO.notNullExpr (OO.call (objectVar, accessMethod));
            theExpression = OO.infixOp (preExpr, OOInfixOp.AND_OP, callMethodExpr);
         }
         else
         {
            throw new IllegalArgumentException ("UMLAttrExprPair: regular expressions are allowed for strings only!");
         }
      }
      else
      {
         OOExpression leftExpr = OO.call (objectVar, accessMethod);
         OOExpression rightExpr = OO.identifier (umlAttrExprPair.getExpression());

         if (isStringType)
         {
            OOCallMethodExpr callMethodExpr = OO.call (OOMethod.STRING_COMPARE_METHOD);
            callMethodExpr.addToParameter (leftExpr);
            callMethodExpr.addToParameter (rightExpr);

            leftExpr = callMethodExpr;
            rightExpr = OO.identifier ("0");
         }

         OOInfixOp theOp = OOInfixOp.get (umlAttrExprPair.getOperation(), umlAttrExprPair.getQualifier());

         theExpression = OO.infixOp (leftExpr, theOp, rightExpr);
      }

      return theExpression;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UmlAttrExprPairOOFunction[]";
   }
}

/*
 * $Log: UmlAttrExprPairOOFunction.java,v $
 * Revision 1.19.2.2  2006/08/01 14:30:48  cschneid
 * improve error message on null attr/type
 *
 */
