/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.*;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.codegen.AccessorOOHandler.MethodDescription;
import de.uni_paderborn.fujaba.metamodel.*;
import de.upb.tools.fca.FHashMap;


/**
 * @author    Carsten Reckord
 * @version   $Revision: 1.7 $
 */
public class UMLRoleOOHandlerToOneStrategy extends UMLRoleOOHandlerStrategy
{
   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The responsible value
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#isResponsible(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   public boolean isResponsible (FRole umlRole, FRole partnerRole)
   {
      return  (umlRole != null && partnerRole != null &&
         getCardinality (partnerRole) == 1 && umlRole.getFQualifier() == null);
   }


   /**
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                             FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createGetMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateWriteAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                              FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createSetMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The attrType value
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#getAttrType(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   protected String getAttrType (FRole umlRole, FRole partnerRole)
   {
      return partnerRole.getFTarget().getFullClassName();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void setupTemplateParameterListeners()
   {
      addToTemplateParameterListeners (new KeyChangeHookListener());
      addToTemplateParameterListeners (new PropertyChangeHookListener());
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createGetMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.GET_METHOD;
      String blockName = "assoc-get-v1";

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName, templateParameters,
         attr.getFAttrType(), null);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createSetMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.SET_METHOD;
      String blockName = "assoc-set-v1";

      String remove = getPartnerAccessMethod (umlRole, partnerRole, SourceCodeFactory.REMOVE_METHOD);
      templateParameters.put ("$REMOVE$", remove);

      return createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected String createPropertyChangeCode (FRole umlRole, FRole partnerRole, FAttr attr,
                                              FHashMap templateParameters)
   {
      return getHandler().createTemplateCode (umlRole, attr,
         templateParameters, "postHook-propertyChange");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected String createOldValueCode (FRole umlRole, FRole partnerRole, FAttr attr,
                                        FHashMap templateParameters)
   {
      return getHandler().createTemplateCode (umlRole, attr,
         templateParameters, "preHook-propertyChange");
   }


   /**
    * Get the keyChangePreHook attribute of the UMLRoleOOHandlerToOneStrategy object
    *
    * @param umlRole  No description provided
    * @return         The keyChangePreHook value
    */
   protected String getKeyChangePreHook (FRole umlRole)
   {
      StringBuffer result = new StringBuffer();
      Iterator qualifiers = umlRole.iteratorOfRevQualifiedRole();
      while (qualifiers.hasNext())
      {
         FQualifier qualifier = (FQualifier) qualifiers.next();
         FRole qualifyingRole = qualifier.getFRevQualifier();
         FRole partnerOfQualifyingRole = qualifyingRole.getFPartnerRole();

         UMLRoleOOHandlerStrategy partnerStrategy = findResponsible (partnerOfQualifyingRole);
         result.append (partnerStrategy.createKeyChangePreHook (partnerOfQualifyingRole, qualifyingRole))
            .append ("\n");
      }
      return result.toString();
   }


   /**
    * Get the keyChangePostHook attribute of the UMLRoleOOHandlerToOneStrategy object
    *
    * @param umlRole  No description provided
    * @return         The keyChangePostHook value
    */
   protected String getKeyChangePostHook (FRole umlRole)
   {
      StringBuffer result = new StringBuffer();
      Iterator qualifiers = umlRole.iteratorOfRevQualifiedRole();
      while (qualifiers.hasNext())
      {
         FQualifier qualifier = (FQualifier) qualifiers.next();
         FRole qualifiedRole = qualifier.getFRevQualifier();
         FRole partnerOfQualifiedRole = qualifiedRole.getFPartnerRole();

         UMLRoleOOHandlerStrategy partnerStrategy = findResponsible (partnerOfQualifiedRole);
         result.append (partnerStrategy.createKeyChangePostHook (partnerOfQualifiedRole, qualifiedRole))
            .append ("\n");
      }
      return result.toString();
   }


   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#createKeyChangePreHook(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   protected String createKeyChangePreHook (FRole umlRole, FRole partnerRole)
   {
      return "";
   }


   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#createKeyChangePostHook(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   protected String createKeyChangePostHook (FRole umlRole, FRole partnerRole)
   {
      return "";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.7 $ $Date: 2004/11/22 19:04:49 $
    */
   private final class KeyChangeHookListener implements TemplateParameterListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param source              No description provided
       * @param element             No description provided
       * @param attr                No description provided
       * @param blockName           No description provided
       * @param templateParameters  No description provided
       */
      public void setupTemplateParameters (AccessorOOHandler source, FElement element, FAttr attr,
                                           String blockName, Map templateParameters)
      {
         if (element instanceof FRole)
         {
            FRole umlRole = (FRole) element;
            FRole partnerRole = umlRole.getFPartnerRole();
            AccessorOOHandler.appendPreHook ((FHashMap) templateParameters, getKeyChangePreHook (partnerRole));
            AccessorOOHandler.appendPostHook ((FHashMap) templateParameters, getKeyChangePostHook (partnerRole));
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.7 $ $Date: 2004/11/22 19:04:49 $
    */
   private final class PropertyChangeHookListener implements TemplateParameterListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param source              No description provided
       * @param element             No description provided
       * @param attr                No description provided
       * @param blockName           No description provided
       * @param templateParameters  No description provided
       */
      public void setupTemplateParameters (AccessorOOHandler source, FElement element, FAttr attr,
                                           String blockName, Map templateParameters)
      {
         if (element instanceof FRole)
         {
            FRole umlRole = (FRole) element;
            FRole partnerRole = umlRole.getFPartnerRole();
            if (isBound (umlRole))
            {
               if (partnerRole.getAdornment() == FRole.REFERENCE)
               {
                  // stores the old value only in case of a reference association
                  // in all other cases, the old value is already stored within
                  // the used association code template
                  String oldValue = createOldValueCode (umlRole, partnerRole, attr,
                     (FHashMap) templateParameters);
                  AccessorOOHandler.appendPreHook ((FHashMap) templateParameters, oldValue);
               }

               String propChange = createPropertyChangeCode (umlRole, partnerRole, attr,
                  (FHashMap) templateParameters);
               AccessorOOHandler.appendPostHook ((FHashMap) templateParameters, propChange);
            }
         }
      }
   }
}

/*
 * $Log: UMLRoleOOHandlerToOneStrategy.java,v $
 * Revision 1.7  2004/11/22 19:04:49  lowende
 * Some javadoc corrections.
 *
 */
