/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Set;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.codegen.AccessorOOHandler.MethodDescription;
import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.upb.tools.fca.FHashMap;


/**
 * @author    Carsten Reckord
 * @version   $Revision: 1.6.2.1 $
 */
public class UMLRoleOOHandlerToManyStrategy extends UMLRoleOOHandlerStrategy
{
   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The responsible value
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#isResponsible(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   public boolean isResponsible (FRole umlRole, FRole partnerRole)
   {
      return  (umlRole != null && partnerRole != null &&
         getCardinality (partnerRole) > 1 && !isSorted (partnerRole) && !isOrdered (partnerRole) &&
         umlRole.getFQualifier() == null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param readAccessMethods   No description provided
    * @param writeAccessMethods  No description provided
    * @return                    No description provided
    */
   public FAttr generateRole (FRole umlRole,
                              Set readAccessMethods, Set writeAccessMethods)
   {
      provideImport (umlRole.getFTarget(), providePackage ("de.upb.tools.fca"));
      provideImport (umlRole.getFTarget(), providePackage ("java.util"));
      return super.generateRole (umlRole, readAccessMethods, writeAccessMethods);
   }


   /**
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                             FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createAddToMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createRemoveFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createRemoveAllFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateWriteAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                              FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createHasInMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIteratorOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createSizeOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateFirstLastReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                                      FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createGetFirstOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createGetLastOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createSizeOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                   FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.SIZE_OF_METHOD;
      String blockName = "assoc-sizeOf-v1";

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.INTEGER);

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createHasInMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                  FHashMap templateParameters)
   {
      return createHasInMethod (umlRole, partnerRole, attr, templateParameters, "assoc-hasIn-v1");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @return                    No description provided
    */
   protected MethodDescription createHasInMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                  FHashMap templateParameters, String blockName)
   {
      int methodType = SourceCodeFactory.HAS_IN_METHOD;

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.BOOLEAN);

      // Generate the method parameter.
      FParam newParam = createParam ("value", partnerRole.getFTarget().getFRealType());

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{newParam});
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIteratorOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters)
   {
      return createIteratorOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-iteratorOf-v1");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIteratorOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters, String blockName)
   {
      int methodType = SourceCodeFactory.ITERATOR_OF_METHOD;
      return createIteratorOfMethod (umlRole, partnerRole, attr, templateParameters, blockName, methodType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIteratorOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters, String blockName,
                                                       int methodType)
   {
      FClass iteratorType =
         provideReference (getIteratorType (partnerRole.getFTarget().getFRealType()));

      FType returnType = iteratorType.getFRealType();

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, null);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createAddToMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                  FHashMap templateParameters)
   {
      return createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-addTo-v1", SourceCodeFactory.ADD_METHOD);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createRemoveFromMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.REMOVE_METHOD;
      String blockName = "assoc-removeFrom-v1";

      return createRemoveMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @return                    No description provided
    */
   protected MethodDescription createRemoveMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                   FHashMap templateParameters, String blockName,
                                                   int methodType)
   {
      return createRemoveMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType, "value", partnerRole.getFTarget().getFRealType());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @param paramName           No description provided
    * @param paramType           No description provided
    * @return                    No description provided
    */
   protected MethodDescription createRemoveMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                   FHashMap templateParameters, String blockName,
                                                   int methodType, String paramName, FType paramType)
   {
      String remove = getPartnerAccessMethod (umlRole, partnerRole, SourceCodeFactory.REMOVE_METHOD);
      templateParameters.put ("$REMOVE$", remove);

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.BOOLEAN);

      // Add method parameter.
      FParam valueParam = createParam (paramName, paramType);

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{valueParam});
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createRemoveAllFromMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                          FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.REMOVE_ALL_FROM_METHOD;
      String blockName = "assoc-removeAllFrom-v1";

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.VOID);

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createGetFirstOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.GET_FIRST_OF_METHOD;
      String blockName = "assoc-getFirstOf";

      FType returnType = partnerRole.getFTarget().getFType();

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createGetLastOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                      FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.GET_LAST_OF_METHOD;
      String blockName = "assoc-getLastOf";

      FType returnType = partnerRole.getFTarget().getFType();

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, null);
   }


   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The attrType value
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#getAttrType(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   protected String getAttrType (FRole umlRole, FRole partnerRole)
   {
      FClass target = umlRole.getFTarget();
      FClass partnerTarget = partnerRole.getFTarget();

      boolean isBound = target.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (
         UMLStereotypeManager.JAVA_BEAN_COMPONENT));

      OOGenVisitor visitor = CodeGenFactory.get().getCurrentOOVisitor();

      OOCollectionEnum containerType = getContainerType();
      return visitor.getOOTypeAsString (
         OO.containerType (containerType, OO.type (partnerTarget, true)),
         isBound);
   }


   /**
    * Get the containerType attribute of the UMLRoleOOHandlerToManyStrategy object
    *
    * @return   The containerType value
    */
   protected OOCollectionEnum getContainerType()
   {
      return OOCollectionEnum.SET;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    */
   protected String generateContructorParam (FRole umlRole, FRole partnerRole)
   {
      // add property name support
      if (isBound (umlRole))
      {
         StringBuffer constructorParam = new StringBuffer();
         constructorParam.append ("this, \"").append (partnerRole.getAttrName()).append ("\"");
         return constructorParam.toString();
      }
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    */
   protected FHashMap setupTemplateParameters (FRole umlRole, FRole partnerRole)
   {
      FHashMap templateParameters = super.setupTemplateParameters (umlRole, partnerRole);

      String constructorParam = generateContructorParam (umlRole, partnerRole);

      templateParameters.put ("$CONTAINER$",
         UMLProject.removePackageFromFullQualifiedType (
         getAttrType (umlRole, partnerRole)));
      templateParameters.put ("$CONSTRUCTORPARAM$",
          (constructorParam == null ? "" : constructorParam.toString()));
      templateParameters.put ("$LINKLISTCODE$", "");

      return templateParameters;
   }


   /**
    * Get the iteratorType attribute of the UMLRoleOOHandlerToManyStrategy object
    *
    * @param valueType  No description provided
    * @return           The iteratorType value
    */
   protected String getIteratorType (FType valueType)
   {
      return getPlainIteratorType (valueType);
   }


   /**
    * Get the plainIteratorType attribute of the UMLRoleOOHandlerToManyStrategy class
    *
    * @param valueType  No description provided
    * @return           The plainIteratorType value
    */
   protected final static String getPlainIteratorType (FType valueType)
   {
      OOGenVisitor visitor = CodeGenFactory.get().getCurrentOOVisitor();
      return visitor.getOOTypeAsString (
         OO.containerType (OOCollectionEnum.ITERATOR, OO.type (valueType,  (valueType instanceof FBaseTypes)))
         , false);
   }


   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#createKeyChangePreHook(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   protected String createKeyChangePreHook (FRole umlRole, FRole partnerRole)
   {
      FHashMap templateParameters = setupKeyChangeParameters (umlRole, partnerRole);
      return getHandler().createTemplateCode (umlRole, null,
         templateParameters, "preHook-keyChange-toN");
   }


   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#createKeyChangePostHook(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   protected String createKeyChangePostHook (FRole umlRole, FRole partnerRole)
   {
      FHashMap templateParameters = setupKeyChangeParameters (umlRole, partnerRole);
      return getHandler().createTemplateCode (umlRole, null,
         templateParameters, "postHook-keyChange-toN");
   }
}

/*
 * $Log: UMLRoleOOHandlerToManyStrategy.java,v $
 * Revision 1.6.2.1  2005/12/22 15:25:36  lowende
 * Patch from Basil for property names of FPropHashSet
 *
 */
