/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.LinkedList;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLPath;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.6 $
 */
public class UMLPathTopOOFunction extends OOGenFunction
{

   /**
    * @param methodName  No description provided
    * @return            The responsible value
    * @see               de.uni_paderborn.fujaba.codegen.CodeGenFunction#isResponsible(java.lang.String)
    */
   public boolean isResponsible (String methodName)
   {
      return UMLPathOOHandler.PATH_SEARCH_TOP.equals (methodName);
   }


   /**
    * @param methodName  No description provided
    * @param param       No description provided
    * @param asgElement  No description provided
    * @return            No description provided
    * @see               de.uni_paderborn.fujaba.codegen.CodeGenFunction#generateCode(de.uni_paderborn.fujaba.metamodel.FElement,
    *      java.lang.String, java.lang.Object[])
    */
   public Object generateCode (FElement asgElement, String methodName, Object[] param)
   {
      UMLPath umlPath = (UMLPath) asgElement;
      UMLStoryPattern pattern = (UMLStoryPattern) umlPath.getFirstFromDiagrams();
      UMLStoryActivity activity = pattern.getRevStoryPattern();

      String sourceObjectName = umlPath.getSource().getObjectName();
      String sourceObjectType = umlPath.getSource().getObjectType();
      String targetObjectName = umlPath.getTarget().getObjectName();
      String targetObjectType = umlPath.getTarget().getObjectType();
      boolean targetBound = umlPath.getTarget().isBound();

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment ("Path search between " + sourceObjectType + " and " + targetObjectType));
      OOStatement.add (statements, OO.lineComment ("Bind " + targetObjectName + " : " + targetObjectType));

      OOVariable iterVar = OO.variable (CGU.upFirstChar (sourceObjectName) + "Path" + CGU.upFirstChar (targetObjectName), OOVariableType.iFujabaIter);

      // iter = new Path(<sourceObjectName>, <expression>);
      OONewObjectExpr newPath = OO.newObject ("Path", new OOStringExpr (sourceObjectName + ", \"" + umlPath.getExpression() + "\""));
      OOStatement.add (statements, OO.varDecl ("FWIterator", iterVar, newPath));

      OOFWIteratorHasNextExpr hasNextExpr = OO.iterHasNext (iterVar, sourceObjectName, OO.type (targetObjectType), true);
      OOExpression notFujabaSuccess = OO.not (OO.identifier (OOVariableType.iFujabaSuccess));
      OOExpression conditionExpr;
      if (activity.isForEach())
      {
         conditionExpr = hasNextExpr;
      }
      else
      {
         conditionExpr = OO.infixOp (notFujabaSuccess, OOInfixOp.AND_OP, hasNextExpr);
      }

      OOStatement.add (statements, OO.whileStat (conditionExpr));

      OOStatement.add (statements, OO.startBlock());
      OOStatement.add (statements, new OOTryStatement());
      OOStatement.add (statements, OO.startBlock());

      // get next element of the iterator.
      OOStatement.add (statements, OO.varDecl (OO.type ("Object"), OO.variable (OOVariableType.iFujabaTmpObject), OO.iterGet (iterVar)));

      // ensure type
      OOStatement.add (statements, OO.ensure (new OOObjectOfTypeExpr (OOVariableType.iFujabaTmpObject, targetObjectType)));

      // cast
      if (targetBound)
      {
         OOStatement.add (statements, OO.assignStat (targetObjectName, OO.typeCast (targetObjectType, OOVariableType.iFujabaTmpObject)));
      }
      else
      {
         OOStatement.add (statements, OO.varDecl (targetObjectType, targetObjectName, OO.typeCast (targetObjectType, OOVariableType.iFujabaTmpObject)));
      }

      OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iterVar)));
      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }

}

/*
 * $Log: UMLPathTopOOFunction.java,v $
 * Revision 1.6  2004/11/23 18:19:57  creckord
 * Fixed some bugs in Story Pattern codegen:
 * <a href="http://uther.uni-paderborn.de/tracker/?func=detail&aid=73&group_id=39&atid=197">Bug #73</a>
 * <a href="http://uther.uni-paderborn.de/tracker/?func=detail&aid=74&group_id=39&atid=197">Bug #74</a>
 * <a href="http://uther.uni-paderborn.de/tracker/?func=detail&aid=98&group_id=39&atid=197">Bug #98</a>
 * <a href="http://uther.uni-paderborn.de/tracker/?func=detail&aid=99&group_id=39&atid=197">Bug #99</a>
 *
 */
