/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.LinkedList;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLPath;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.6 $
 */
public class UMLPathSearchToSetTopOOFunction extends OOGenFunction
{

   /**
    * @param methodName  No description provided
    * @return            The responsible value
    * @see               de.uni_paderborn.fujaba.codegen.CodeGenFunction#isResponsible(java.lang.String)
    */
   public boolean isResponsible (String methodName)
   {
      return UMLPathOOHandler.PATH_SEARCH_TO_SET_TOP.equals (methodName);
   }


   /**
    * Describe <code>generateCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param param       No description provided
    * @param asgElement  No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    * @see               de.uni_paderborn.fujaba.codegen.CodeGenFunction#generateCode(de.uni_paderborn.fujaba.metamodel.FElement,
    *      java.lang.String, java.lang.Object[])
    */
   public Object generateCode (FElement asgElement, String methodName, Object[] param)
   {
      UMLPath umlPath = (UMLPath) asgElement;

      String sourceObjectName = umlPath.getSource().getObjectName();
      String sourceObjectType = umlPath.getSource().getObjectType();
      String targetObjectName = umlPath.getTarget().getObjectName();
      String targetObjectType = umlPath.getTarget().getObjectType();

      LinkedList statements = new LinkedList();

      // comment
      OOStatement.add (statements, OO.lineComment ("Path search between " + sourceObjectType + " and " + targetObjectType));
      OOStatement.add (statements, OO.lineComment ("Bind set of " + targetObjectType));

      // define a new empty treeset.
      OOContainerType tmpContainerType = OO.containerType (OOCollectionEnum.HASHTABLE, OO.type (sourceObjectType, true));
      OOStatement.add (statements, OO.varDecl (tmpContainerType, OO.variable (targetObjectName), OO.newObject (tmpContainerType)));

      // define unique iterator name
      OOVariable iterVar = OO.variable (CGU.upFirstChar (targetObjectName), OOVariableType.iFujabaIter);

      // create iterator
      // iter = new Path(<sourceObjectName>, <expression>);
      OONewObjectExpr newPath = OO.newObject ("Path", new OOStringExpr (sourceObjectName + ", \"" + umlPath.getExpression() + "\""));
      OOStatement.add (statements, OO.varDecl ("FWIterator", iterVar, newPath));

      // begin while loop
      OOFWIteratorHasNextExpr hasNextExpr = OO.iterHasNext (iterVar, sourceObjectName, OO.type (targetObjectType), true);
      OOStatement.add (statements, OO.whileStat (hasNextExpr));

      // begin while block
      OOStatement.add (statements, OO.startBlock());

      // begin try block
      OOStatement.add (statements, new OOTryStatement());
      OOStatement.add (statements, OO.startBlock());

      // assign iter.next() to temporal variable
      OOVariable tmpVar = OO.variable (OOVariableType.iFujabaTmpObject);
      OOStatement.add (statements, OO.varDecl ("Object", tmpVar,
         OO.iterGet (iterVar)));
      OOStatement.add (statements, OO.ensure (new OOObjectOfTypeExpr (OOVariableType.iFujabaTmpObject, targetObjectType)));
      OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iterVar)));
      // cast
      OOVariable tmpVarCasted = OO.variable (targetObjectType, OOVariableType.iFujabaTmpObject);
      OOStatement.add (statements, OO.varDecl (targetObjectType, tmpVarCasted, OO.typeCast (targetObjectType, OOVariableType.iFujabaTmpObject)));

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLPathSearchToSetTopOOFunction[]";
   }
}

/*
 * $Log: UMLPathSearchToSetTopOOFunction.java,v $
 * Revision 1.6  2005/02/08 15:46:21  cschneid
 * path search bugfix, method signature can be edited in diagram
 *
 */
