/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class UMLObjectOOHandler
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.18.2.1 $
 */
public class UMLObjectOOHandler extends OOGenStrategyHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLObjectOOHandler.class);


   /**
    * Default Constructor
    */
   public UMLObjectOOHandler() { }


   /**
    * Get the responsible attribute of the UMLObjectOOHandler object
    *
    * @param incr  No description provided
    * @return      The responsible value
    */
   public boolean isResponsible (FElement incr)
   {
      return  (incr instanceof UMLObject);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public final boolean needToken()
   {
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr       No description provided
    * @param prevToken  No description provided
    * @param param      No description provided
    * @return           No description provided
    */
   public OOGenToken generateSourceCode (FElement incr,
                                         OOGenToken prevToken,
                                         Object param[])
   {
      UMLObject theUMLObject = (UMLObject) incr;

      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(theUMLObject=" +
            theUMLObject + ")");
      }

      // parse params
      try
      {
          ((Boolean) param[0]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException (this + ".generateSourceCode(" +
            param + ")");
      }

      // OOGenStrategyClient client = (OOGenStrategyClient) getClientOfChain();

      prevToken = prevToken.insertNewToken ("ObjectModify");

      if (theUMLObject.getModifier() == UMLObject.CREATE)
      {
         prevToken.appendStatement (generateCode (theUMLObject,
            OBJECT_CREATE,
            new Object[]{
            theUMLObject.getObjectName(),
            theUMLObject.getInstanceOf(),
            theUMLObject.getObjectType(),
            Boolean.valueOf (theUMLObject.isOptional())
            }
            ));

         if (log.isDebugEnabled())
         {
            log.debug ("Create object : name = '" + theUMLObject.getObjectName() + "'");
         }
      }
      else
      {
         prevToken.appendStatement (generateCode (theUMLObject, OBJECT_DELETE, null));

         if (log.isDebugEnabled())
         {
            log.debug ("Delete object : name = '" + theUMLObject.getObjectName() + "'");
         }
      }

      return prevToken;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLObjectOOHandler[]";
   }
}

/*
 * $Log: UMLObjectOOHandler.java,v $
 * Revision 1.18.2.1  2005/07/13 11:24:50  creckord
 * Fixed problem with objects of classes with same name but different packages
 *
 */
