/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;

import org.apache.log4j.Logger;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;


/**
 * Class UMLFileOOHandler
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.33.2.2 $
 */
public class UMLFileOOHandler
    extends OOGenStrategyHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLFileOOHandler.class);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FRAGMENT_CLASSES = "File:Classes";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FRAGMENT_FILE_HEADER = "File:Header";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FRAGMENT_FILE_FOOTER = "File:Footer";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FRAGMENT_IMPORTS = "File:Imports";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CREATE_IMPORTS_FUNCTION = "createImportsForFile";


   /**
    * Default Constructor
    */
   public UMLFileOOHandler()
   {
      super();
   }


   /**
    * Get the responsible attribute of the UMLFileOOHandler object
    *
    * @param incr  No description provided
    * @return      The responsible value
    */
   public boolean isResponsible (FElement incr)
   {
      return  (incr instanceof FFile);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public final boolean needToken()
   {
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr       No description provided
    * @param prevToken  No description provided
    * @param param      No description provided
    * @return           No description provided
    */
   public OOGenToken generateSourceCode (FElement incr,
                                         OOGenToken prevToken,
                                         Object param[])
   {
      FFile theFile = (FFile) incr;
      OOGenStrategyClient client = (OOGenStrategyClient) getClientOfChain();

      // don't write files for EditTextAction
      boolean writeFiles = true;

      if (param != null && param.length == 1)
      {
         if (param[0] instanceof Boolean)
         {
            writeFiles =  ((Boolean) param[0]).booleanValue();
         }
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(theFile=" + theFile +
            ",path=" + client.getFilePath (theFile) +
            ",name=" + client.getFileName (theFile) +
            ",target=" + client.getCurrentOOGenVisitor() + ")");
      }

      // ignore reference, ...
      if (!necessaryToCreateFile (theFile))
      {
         if (log.isDebugEnabled())
         {
            if (log.isInfoEnabled())
            {
               log.info (this + " ignore FFile:" + theFile);
            }
         }
      }
      else
      {
         client.initVisitor (client.getFilePath (theFile),
            client.getFileName (theFile),
            writeFiles);

         // generate header (documentation)
         generateFFileHeader (theFile);

         // start with package decl
         generateFPackageBegin (theFile);

         generateImportList (theFile);

         client.getCurrentVisitor().appendTextFragment (FRAGMENT_CLASSES);

         // generate all UMLCLasses
         FClass tmpFClass = null;
         Iterator tmpIter = theFile.iteratorOfContains();

         while (tmpIter.hasNext())
         {
            tmpFClass = (FClass) tmpIter.next();
            getClientOfChain().generateSourceCodeFor (tmpFClass, null, null);
         }

         // end package decl
         generateFPackageEnd (theFile);

         // generate footer (documentation)
         generateFFileFooter (theFile);

         if (writeFiles)
         {
            client.writeFiles();
         }
      }

      // has no tokens
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public final void generateFFileHeader (FFile theFile)
   {
      if (log.isDebugEnabled())
      {
         if (log.isInfoEnabled())
         {
            log.info (this + ".generateFFileHeader(" + theFile + ")");
         }
      }

      OOGenStrategyClient client = (OOGenStrategyClient) getClientOfChain();
      client.getCurrentVisitor().appendTextFragment (FRAGMENT_FILE_HEADER);

      if (theFile.getFComment() != null)
      {
         client.append (theFile.getFComment().getText());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public final void generateFFileFooter (FFile theFile)
   {
      if (log.isDebugEnabled())
      {
         if (log.isInfoEnabled())
         {
            log.info (this + ".generateFFileFooter(" + theFile + ")");
         }
      }

      OOGenStrategyClient client = (OOGenStrategyClient) getClientOfChain();
      client.getCurrentVisitor().appendTextFragment (FRAGMENT_FILE_FOOTER);

      if (theFile.getFooter() != null)
      {
         getClientOfChain().append (theFile.getFooter());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public final void generateFPackageBegin (FFile theFile)
   {
      if (log.isDebugEnabled())
      {
         if (log.isInfoEnabled())
         {
            log.info (this + ".generateFPackageBegin(" + theFile + ")");
         }
      }

       ((OOGenStrategyClient) getClientOfChain()).generateFPackageBegin (theFile);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public final void generateFPackageEnd (FFile theFile)
   {
      if (log.isDebugEnabled())
      {
         if (log.isInfoEnabled())
         {
            log.info (this + ".generateFPackageEnd(" + theFile + ")");
         }
      }

       ((OOGenStrategyClient) getClientOfChain()).generateFPackageEnd (theFile);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public final void generateImportList (FFile theFile)
   {
      if (log.isDebugEnabled())
      {
         if (log.isInfoEnabled())
         {
            log.info (this + ".generateImportList(" + theFile + ")");
         }
      }

      FPackage tmpPackage = null;
      FClass tmpClass = null;
      OOGenStrategyClient client = (OOGenStrategyClient) getClientOfChain();
      ImportFragment importFragment = new ImportFragment (FRAGMENT_IMPORTS, client);
      client.getCurrentVisitor().appendFragment (importFragment);

      Iterator importIter = theFile.iteratorOfImportedPackages();

      while (importIter.hasNext())
      {
         tmpPackage = (FPackage) importIter.next();
         importFragment.addPackage (tmpPackage);
      }

      importIter = theFile.iteratorOfImportedClasses();

      while (importIter.hasNext())
      {
         tmpClass = (FClass) importIter.next();
         importFragment.addClass (tmpClass);
      }
      generateImplicitImports (theFile, importFragment);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    * @return         No description provided
    */
   public boolean necessaryToCreateFile (FFile theFile)
   {
      boolean create = false;
      Iterator iter = theFile.iteratorOfContains();
      while (!create && iter.hasNext())
      {
         FClass tmpClass = (FClass) iter.next();
         create = necessaryToCreateClass (tmpClass);
      }
      // if (log.isInfoEnabled()) log.info ("necessaryToCreateFile(" + theFile + ")=" + create);

      return create;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param tmpClass  No description provided
    * @return          No description provided
    */
   public boolean necessaryToCreateClass (FClass tmpClass)
   {
      return ! (tmpClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.REFERENCE)) ||
         tmpClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.IMPORT)));
   } // necessaryToCreateClass


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param visitor  No description provided
    * @return         No description provided
    */
   public static ImportFragment findImportFragment (CodeGenVisitor visitor)
   {
      if (visitor != null)
      {
         CodeGenFragment fragment = visitor.getFirstFragment();
         while (fragment != null)
         {
            if (FRAGMENT_IMPORTS.equals (fragment.getName()) && fragment instanceof ImportFragment)
            {
               return (ImportFragment) fragment;
            }
            fragment = fragment.getNextFragment();
         }
      }
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlFile     No description provided
    * @param importFrag  No description provided
    */
   public void generateImplicitImports (final FFile umlFile, final ImportFragment importFrag)
   {

      Runnable runnable =
         new Runnable()
         {
            public void run()
            {
               generateCode (umlFile, CREATE_IMPORTS_FUNCTION, new Object[]{importFrag});
            }
         };
      FujabaChangeManager.executeTransient (runnable);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLFileOOHandler[]";
   }
}

/*
 * $Log: UMLFileOOHandler.java,v $
 * Revision 1.33.2.2  2006/02/28 13:44:01  cschneid
 * fixed garbage resulting from code generation
 *
 */
