/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Comparator;

import de.uni_paderborn.fujaba.metamodel.*;


/**
 * @author    <a href="mailto:creckord@upb.de">Carsten Reckord</a>
 * @version   $Revision: 1.3 $
 */
public abstract class UMLClassBodyStrategy
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEFAULT = -1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int PROHIBIT = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int REQUIRE = 1;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlClass  No description provided
    */
   public abstract void createContents (FClass umlClass);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param boolFlag  No description provided
    * @param intFlag   No description provided
    * @return          No description provided
    */
   protected boolean checkFlag (boolean boolFlag, int intFlag)
   {
      switch (intFlag)
      {
         case DEFAULT:
            return true;
         case REQUIRE:
            return  (boolFlag == true);
         case PROHIBIT:
            return  (boolFlag == false);
      }
      return false;
   }


   /**
    * <pre>
    *                    0..1                Assoc                n
    * UMLClassOOHandler -------------------------------------------- UMLClassBodyStrategy
    *                    classHandler   {ordered,}   bodyStrategies
    * </pre>
    */
   private UMLClassOOHandler classHandler;


   /**
    * Get the classHandler attribute of the UMLClassBodyStrategy object
    *
    * @return   The classHandler value
    */
   public UMLClassOOHandler getClassHandler()
   {
      return this.classHandler;
   }


   /**
    * Sets the classHandler attribute of the UMLClassBodyStrategy object
    *
    * @param value  The new classHandler value
    * @return       No description provided
    */
   public boolean setClassHandler (UMLClassOOHandler value)
   {
      boolean changed = false;
      if (this.classHandler != value)
      {
         if (this.classHandler != null)
         {
            UMLClassOOHandler oldValue = this.classHandler;
            this.classHandler = null;
            oldValue.removeFromBodyStrategies (this);
         }
         this.classHandler = value;
         if (value != null)
         {
            value.addToBodyStrategies (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.3 $ $Date: 2004/11/14 18:58:29 $
    */
   public static class AttrComparator implements Comparator
   {
      /**
       * @param o1  No description provided
       * @param o2  No description provided
       * @return    No description provided
       * @see       java.util.Comparator#compare(java.lang.Object, java.lang.Object)
       */
      public int compare (Object o1, Object o2)
      {
         if (! (o1 instanceof FAttr && o2 instanceof FAttr))
         {
            throw new IllegalArgumentException ("AttrComparator.compare(Object, Object): arguments must be of type FAttr!");
         }
         FAttr umlAttr1 = (FAttr) o1;
         FAttr umlAttr2 = (FAttr) o2;

         return umlAttr1.getName().compareTo (umlAttr2.getName());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.3 $ $Date: 2004/11/14 18:58:29 $
    */
   public static class MethodComparator implements Comparator
   {
      /**
       * @param o1  No description provided
       * @param o2  No description provided
       * @return    No description provided
       * @see       java.util.Comparator#compare(java.lang.Object, java.lang.Object)
       */
      public int compare (Object o1, Object o2)
      {
         FMethod umlMethod1 = (FMethod) o1;
         FMethod umlMethod2 = (FMethod) o2;

         int result;
         if ("removeYou".equals (umlMethod1.getName()))
         {
            result = 1;
         }
         else if ("removeYou".equals (umlMethod2.getName()))
         {
            result = -1;
         }
         else
         {
            result = umlMethod1.getFullMethodName().compareTo (umlMethod2.getFullMethodName());
         }

         return result;
      }
   }
}

/*
 * $Log: UMLClassBodyStrategy.java,v $
 * Revision 1.3  2004/11/14 18:58:29  lowende
 * The code of parsed members of a class is generated in the order they have been read.
 *
 */
