/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.*;

import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.uml.UMLRole;


/**
 * @author    <a href="mailto:creckord@upb.de">Carsten Reckord</a>
 * @version   $Revision: 1.6 $
 */
public class UMLClassBodyAttributesStrategy extends UMLClassBodyStrategy
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEFAULT = -1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int PROHIBIT = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int REQUIRE = 1;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlClass  No description provided
    */
   public void createContents (FClass umlClass)
   {
      //FIXME: We need to implement attributes of implemented interfaces, too
      SortedSet attrs = getAttributes (umlClass);
      Iterator iter = attrs.iterator();
      while (iter.hasNext())
      {
         FAttr attr = (FAttr) iter.next();
         if (isResponsible (attr))
         {
            createAttr (attr);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param attr  No description provided
    */
   protected void createAttr (FAttr attr)
   {
      getClassHandler().generateFAttr (attr);
   }


   /**
    * Get the responsible attribute of the FClassBodyAttributesStrategy object
    *
    * @param attr  No description provided
    * @return      The responsible value
    */
   protected boolean isResponsible (FAttr attr)
   {
      return  (!attr.isParsed() &&
          (attr.getFImplementingAssocRole() == null) &&
          (checkFlag (attr.isStatic(), createStatic)) &&
          (checkFlag (attr.isFinal(), createFinal)) &&
         !hasRole (attr.getFParent(), attr.getName()));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlClass  No description provided
    * @param name      No description provided
    * @return          No description provided
    */
   private boolean hasRole (FClass umlClass, String name)
   {
      Iterator roles = umlClass.iteratorOfRoles();
      while (roles.hasNext())
      {
         UMLRole role = (UMLRole) roles.next();
         role = role.getPartnerRole();
         if (role != null && name.equals (role.getName()))
         {
            return true;
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param boolFlag  No description provided
    * @param intFlag   No description provided
    * @return          No description provided
    */
   protected boolean checkFlag (boolean boolFlag, int intFlag)
   {
      switch (intFlag)
      {
         case DEFAULT:
            return true;
         case REQUIRE:
            return  (boolFlag == true);
         case PROHIBIT:
            return  (boolFlag == false);
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int createFinal = DEFAULT;


   /**
    * Get the createFinal attribute of the FClassBodyAttributesStrategy object
    *
    * @return   The createFinal value
    */
   public boolean isCreateFinal()
   {
      return this.createFinal == REQUIRE;
   }


   /**
    * Sets the createFinal attribute of the FClassBodyAttributesStrategy object
    *
    * @param createFinal  The new createFinal value
    */
   public void setCreateFinal (boolean createFinal)
   {
      setCreateFinal (createFinal ? REQUIRE : PROHIBIT);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void resetCreateFinal()
   {
      setCreateFinal (DEFAULT);
   }


   /**
    * Sets the createFinal attribute of the FClassBodyAttributesStrategy object
    *
    * @param createFinal  The new createFinal value
    */
   public void setCreateFinal (int createFinal)
   {
      if (createFinal == DEFAULT || createFinal == REQUIRE || createFinal == PROHIBIT)
      {
         this.createFinal = createFinal;
      }
      else
      {
         throw new IllegalArgumentException();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int createStatic = DEFAULT;


   /**
    * Get the createStatic attribute of the FClassBodyAttributesStrategy object
    *
    * @return   The createStatic value
    */
   public boolean isCreateStatic()
   {
      return this.createStatic == REQUIRE;
   }


   /**
    * Sets the createStatic attribute of the FClassBodyAttributesStrategy object
    *
    * @param createStatic  The new createStatic value
    */
   public void setCreateStatic (boolean createStatic)
   {
      setCreateStatic (createStatic ? REQUIRE : PROHIBIT);
   }


   /**
    * Sets the createStatic attribute of the FClassBodyAttributesStrategy object
    *
    * @param createStatic  The new createStatic value
    */
   public void setCreateStatic (int createStatic)
   {
      if (createStatic == DEFAULT || createStatic == REQUIRE || createStatic == PROHIBIT)
      {
         this.createStatic = createStatic;
      }
      else
      {
         throw new IllegalArgumentException();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void resetCreateStatic()
   {
      setCreateStatic (DEFAULT);
   }


   /**
    * Get the attributes attribute of the FClassBodyAttributesStrategy object
    *
    * @param umlClass  No description provided
    * @return          The attributes value
    */
   protected SortedSet getAttributes (FClass umlClass)
   {
      // create sorted set of attributes
      TreeSet attrsSet = new TreeSet (new AttrComparator());
      Iterator attrsIter = umlClass.iteratorOfAttrs();
      while (attrsIter.hasNext())
      {
         attrsSet.add (attrsIter.next());
      }
      return attrsSet;
   }


   /**
    * Get the accessMethods attribute of the FClassBodyAttributesStrategy object
    *
    * @param attr  No description provided
    * @return      The accessMethods value
    */
   protected SortedSet getAccessMethods (FAttr attr)
   {
      // sort access methods
      TreeSet accessMethodsSet = new TreeSet (new MethodComparator());
      Iterator accessMethodsIter = attr.iteratorOfAccessMethods();
      while (accessMethodsIter.hasNext())
      {
         accessMethodsSet.add (accessMethodsIter.next());
      }
      return accessMethodsSet;
   }
}

/*
 * $Log: UMLClassBodyAttributesStrategy.java,v $
 * Revision 1.6  2004/11/14 18:58:29  lowende
 * The code of parsed members of a class is generated in the order they have been read.
 *
 */
