/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.fca.FHashMap;


/**
 * Class FAttrOOHandler
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.25.2.2 $
 */
public class UMLAttrOOHandler
    extends AccessorOOHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLAttrOOHandler.class);


   /**
    * Default Constructor
    */
   public UMLAttrOOHandler()
   {
      super();
      addToTemplateParameterListeners (new PropertyChangeHookListener());
   }


   /**
    * Get the responsible attribute of the FAttrOOHandler object
    *
    * @param incr  No description provided
    * @return      The responsible value
    */
   public boolean isResponsible (FElement incr)
   {
      return  (incr instanceof FAttr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public final boolean needToken()
   {
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr       No description provided
    * @param prevToken  No description provided
    * @param param      No description provided
    * @return           No description provided
    */
   public OOGenToken generateSourceCode (FElement incr,
                                         OOGenToken prevToken,
                                         Object param[])
   {
      FAttr theAttr = (FAttr) incr;
      if (log.isDebugEnabled())
      {
         log.debug (this + ".generate(theAttr=" + theAttr + ")");
      }

      generateAttrCode (theAttr);

      return super.generateSourceCode (incr, prevToken, param);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "FAttrOOHandler[]";
   }


   /**
    * Get the templateFileName attribute of the FAttrOOHandler object
    *
    * @param element  No description provided
    * @return         The templateFileName value
    */
   protected String getTemplateFileName (FElement element)
   {
      CodeGenVisitor visitor = CodeGenFactory.get().getCurrentOOVisitor();
      if (visitor instanceof OOGenVisitor)
      {
         return  ((OOGenVisitor) visitor).getAssocTemplateName();
      }
      return "Templates/AssocTemplateFCA.tpl";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param element        No description provided
    * @param accessMethods  No description provided
    * @return               No description provided
    * @see                  de.uni_paderborn.fujaba.codegen.AccessorOOHandler#createAccessorDescriptions(de.uni_paderborn.fujaba.metamodel.FElement,
    *      java.util.Set)
    */
   protected FAttr createAccessorDescriptions (FElement element, Set accessMethods)
   {
      FAttr attr = (FAttr) element;

      if (attr.isNeedsAccessMethods() && !attr.isParsed())
      {
         MethodDescription accessMethod;
         FHashMap templateParameters = setupTemplateParameters (attr);

         accessMethod = createGetMethod (attr,
            (FHashMap) templateParameters.clone());
         accessMethods.add (accessMethod);

         if (!attr.isFinal())
         {
            accessMethod = createSetMethod (attr, (FHashMap) templateParameters.clone());
            accessMethods.add (accessMethod);
         }
      }
      return attr;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlAttr  No description provided
    * @return         No description provided
    */
   protected FHashMap setupTemplateParameters (FAttr umlAttr)
   {
      FHashMap templateParameters = new FHashMap();
      templateParameters.put ("$FIELDNAME$", umlAttr.getName());
      templateParameters.put ("$VALUETYPE$", umlAttr.getFAttrType().getProgLangType());

      templateParameters.put ("$CHANGE_PREHOOK$", "");
      templateParameters.put ("$CHANGE_POSTHOOK$", "");

      String attrClass = umlAttr.getFAttrType().getName();
      templateParameters.put ("$ATTRCLASS$", attrClass);

      return templateParameters;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   public static MethodDescription createSetMethod (FAttr attr, FHashMap templateParameters)
   {
      // create setter method
      FType attrType = attr.getFAttrType();
      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.VOID);
      String blockName = "accessor-set";
      int methodType = SourceCodeFactory.SET_METHOD;

      SourceCodeFactory factory = UMLProject.getSourceCodeFactory();
      String methodName = factory.getAccessMethodName (attr.getName(), methodType);

      // Create new set method.
      FMethod umlMethod = new UMLMethod (false);

      umlMethod.setName (methodName);
      umlMethod.setStatic (attr.isStatic());
      umlMethod.setResultType (returnType);
      umlMethod.setVisibility (attr.getVisibility());
      umlMethod.setAccessedAttribute (attr);
      umlMethod.setGenerated (true);

      // create setter method
      FParam param = new UMLParam (false);
      param.setName ("value");
      param.setParamType (attrType);
      param.setGenerated (true);
      umlMethod.addToParam (param);

      return new MethodDescription (umlMethod, blockName, templateParameters);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   public static MethodDescription createGetMethod (FAttr attr, FHashMap templateParameters)
   {
      // create getter method
      FType attrType = attr.getFAttrType();
      FType boolType = UMLProject.get().getFromBaseTypes (FBaseTypes.BOOLEAN);

      String blockName = "accessor-get";

      int methodType =  (boolType.getName().equals (attrType.getName()) ? SourceCodeFactory.IS_METHOD :
         SourceCodeFactory.GET_METHOD);

      SourceCodeFactory factory = UMLProject.getSourceCodeFactory();
      String methodName = factory.getAccessMethodName (attr.getName(), methodType);

      // Create new set method.
      FMethod umlMethod = new UMLMethod (false);

      umlMethod.setName (methodName);
      umlMethod.setStatic (attr.isStatic());
      umlMethod.setResultType (attrType);
      umlMethod.setVisibility (attr.getVisibility());
      umlMethod.setAccessedAttribute (attr);
      umlMethod.setGenerated (true);

      return new MethodDescription (umlMethod, blockName, templateParameters);
   }


   /**
    * Get the target attribute of the FAttrOOHandler object
    *
    * @param element  No description provided
    * @param attr     No description provided
    * @return         The target value
    * @see            de.uni_paderborn.fujaba.codegen.AccessorOOHandler#getTarget(de.uni_paderborn.fujaba.metamodel.FElement,
    *      de.uni_paderborn.fujaba.metamodel.FAttr)
    */
   public FClass getTarget (FElement element, FAttr attr)
   {
      return attr.getFParent();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected String createPropertyChangeCode (FAttr attr,
                                              FHashMap templateParameters)
   {
      return createTemplateCode (attr, attr,
         templateParameters, "postHook-propertyChange");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected String createOldValueCode (FAttr attr,
                                        FHashMap templateParameters)
   {
      return createTemplateCode (attr, attr,
         templateParameters, "preHook-propertyChange");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.25.2.2 $ $Date: 2006/03/28 11:15:46 $
    */
   private final class PropertyChangeHookListener implements TemplateParameterListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param source              No description provided
       * @param element             No description provided
       * @param attr                No description provided
       * @param blockName           No description provided
       * @param templateParameters  No description provided
       */
      public void setupTemplateParameters (AccessorOOHandler source, FElement element, FAttr attr,
                                           String blockName, Map templateParameters)
      {
         if (element instanceof FAttr)
         {
            FClass umlClass = attr.getFParent();
            if (umlClass != null && umlClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (
               UMLStereotypeManager.JAVA_BEAN_COMPONENT)))
            {
               String oldValueCode = createOldValueCode (attr,
                  (FHashMap) templateParameters);
               AccessorOOHandler.appendPreHook ((FHashMap) templateParameters, oldValueCode);

               String propChange = createPropertyChangeCode (attr,
                  (FHashMap) templateParameters);
               AccessorOOHandler.appendPostHook ((FHashMap) templateParameters, propChange);
            }
         }
      }
   }
}

/*
 * $Log: UMLAttrOOHandler.java,v $
 * Revision 1.25.2.2  2006/03/28 11:15:46  cschneid
 * fixed accessor generation for interfaces, jnlp shortcut
 *
 * Revision 1.25.2.1  2005/08/23 08:24:41  lowende
 * Removed compile warnings.
 *
 */
