/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class TypeCastOOFunction
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.16.2.1 $
 */
public class TypeCastOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (TypeCastOOFunction.class);


   /**
    * Default Constructor
    */
   public TypeCastOOFunction() { }


   /**
    * Get the responsible attribute of the TypeCastOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.TYPE_CAST.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param param       No description provided
    * @param asgElement  No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement asgElement, String methodName, Object param[])
   {
      UMLObject umlObject = (UMLObject) asgElement;

      String castTarget = umlObject.getObjectName();
      FType castType = umlObject.getInstanceOf();
      String castTypeStr = umlObject.getObjectType();
      String castSource = UMLStoryPatternOOHandler.TEMPORARY_TYPE_CAST_VAR_NAME;

      if (log.isDebugEnabled())
      {
         log.debug (this + ".typeCast(" + umlObject + ")");
      }

      //castTarget = UMLStoryPatternOOHandler.TEMPORARY_ASSIGN_VAR_PREFIX + CGU.upFirstChar (castTarget);

      LinkedList statements = new LinkedList();
      statements.add (OO.lineComment ("explicit type cast"));
      statements.add (castType == null ?
         OO.varDecl (castTypeStr, castTarget, OO.typeCast (castType, OO.variable (castSource))) :
         OO.varDecl (castType, castTarget, OO.typeCast (castType, OO.variable (castSource))));
      statements.add (OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "TypeCastOOFunction[]";
   }
}

/*
 * $Log: TypeCastOOFunction.java,v $
 * Revision 1.16.2.1  2005/07/13 11:24:50  creckord
 * Fixed problem with objects of classes with same name but different packages
 *
 */
