/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * Class ReturnStatOOFunction
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class ReturnStatOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (ReturnStatOOFunction.class);


   /**
    * Default Constructor
    */
   public ReturnStatOOFunction() { }


   /**
    * Get the responsible attribute of the ObjectCreateOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.RETURN_STAT.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String returnValue;
      boolean generateCode;
      boolean returnsVariable;

      // parse params
      try
      {
         returnValue = (String) param[0];
         generateCode =  ((Boolean) param[1]).booleanValue();
         returnsVariable =  ((Boolean) param[2]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".objectCreate("
            + "returnValue=" + returnValue
            + ",generateCode=" + generateCode
            + ",returnsVariable=" + returnsVariable
            );
      }

      LinkedList statements = new LinkedList();

      // check if code is to be produced
      if (generateCode)
      {
         // for 'void methods' and 'constructors' returnVariable()=false
         // -> return;
         if (returnsVariable)
         {
            OOStatement.add (statements, OO.returnStat (returnValue));
         }
         else
         {
            OOStatement.add (statements, OO.returnStat ((OOExpression) null));
         }
      }

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "ReturnStatOOFunction[]";
   }
}

/*
 * $Log: ReturnStatOOFunction.java,v $
 * Revision 1.8  2004/10/20 17:49:35  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
