/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * Class PreconditionCheckOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.24.2.3 $
 */
public class PreconditionCheckOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (PreconditionCheckOOFunction.class);


   /**
    * Default Constructor
    */
   public PreconditionCheckOOFunction() { }


   /**
    * Get the responsible attribute of the PreconditionCheckOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.PRECONDITION_CHECK.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String objectName;
      String toType;
      boolean bound;
      boolean optional;
      boolean set;
      boolean negative;
      boolean assertStmt;
      OOExpression[] umlAttrExprPairs;

      // parse param
      try
      {
         objectName = (String) param[0];
         toType = (String) param[1];
         bound =  ((Boolean) param[2]).booleanValue();
         optional =  ((Boolean) param[3]).booleanValue();
         set =  ((Boolean) param[4]).booleanValue();
         negative =  ((Boolean) param[5]).booleanValue();
         assertStmt =  ((Boolean) param[6]).booleanValue();
         umlAttrExprPairs = (OOExpression[]) param[7];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".preconditionCheck(" +
            "objectName=" + objectName +
            ",toType=" + toType +
            ",bound=" + bound +
            ",optional=" + optional +
            ",set=" + set +
            ",negative=" + negative +
            ",assert=" + assertStmt +
            ",umlAttrExprPairs=" +
            Arrays.asList (umlAttrExprPairs) + ")");
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment ("attribute condition"));

      OOInfixExprLeft attrExpr = null;
      OOExpression conditionExpr = null;

      for (int i = 0; i < umlAttrExprPairs.length; i++)
      {
         if (attrExpr == null)
         {
            attrExpr = new OOInfixExprLeft (umlAttrExprPairs[i]);
         }
         else
         {
            attrExpr.append (OOInfixOp.AND_OP, umlAttrExprPairs[i]);
         }
      }

      if (optional && !set)
      {
         OOStatement.add (statements, OO.ifStat (OO.notNullExpr (objectName)));
         OOStatement.add (statements, OO.startBlock());
      }
      {
         /*
          *  if (negative)
          *  {
          *  conditionExpr = OO.not (attrExpr);
          *  }
          *  else
          */
         conditionExpr = attrExpr;
      }

      if (assertStmt)
      {
         OOGenVisitor tmpVisitor = new JavaGenVisitor();
         OOStatement.add (statements, OO.assertStmt (conditionExpr,
            "attribute condition of object " + objectName + " not met: " + escape (conditionExpr.getSourceCode (tmpVisitor))));
      }
      else
      {
         OOStatement.add (statements, OO.ensure (conditionExpr));
      }

      if (optional && !set)
      {
         OOStatement.add (statements, OO.endBlock ("if"));
      }

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * replaces " by \"
    *
    * @param sourceCode  what to escape
    * @return            escaped source code
    */
   private String escape (String sourceCode)
   {
      return sourceCode.replaceAll ("\\\"", "\\\\\"");
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "PreconditionCheckOOFunction[]";
   }
}

/*
 * $Log: PreconditionCheckOOFunction.java,v $
 * Revision 1.24.2.3  2005/08/23 08:24:41  lowende
 * Removed compile warnings.
 *
 */
