/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;




/**
 * Class OOVariable
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.15 $
 */
public final class OOVariable
    extends OOSingleExpr
    implements Comparable
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariable FUJABA_SUCCESS = new OOVariable ("", OOVariableType.iFujabaSuccess, "");
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariable FUJABA_TMP_OBJECT = new OOVariable ("", OOVariableType.iFujabaTmpObject, "");
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariable FUJABA_EXCEPTION_VARIABLE = new OOVariable ("", OOVariableType.iBreakExceptionVariable, "");


   /**
    * Default Constructor
    *
    * @param firstName   No description provided
    * @param type        No description provided
    * @param secondName  No description provided
    */
   public OOVariable (String firstName, OOVariableType type, String secondName)
   {
      this.firstName = firstName;
      this.type = type;
      this.secondName = secondName;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String firstName = null;


   /**
    * Get the firstName attribute of the OOVariable object
    *
    * @return   The firstName value
    */
   public String getFirstName()
   {
      return this.firstName;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String secondName = null;


   /**
    * Get the secondName attribute of the OOVariable object
    *
    * @return   The secondName value
    */
   public String getSecondName()
   {
      return this.secondName;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private OOVariableType type;


   /**
    * Get the type attribute of the OOVariable object
    *
    * @return   The type value
    */
   public OOVariableType getType()
   {
      return this.type;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public boolean equals (Object other)
   {
      return  (this.compareTo (other) == 0);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public int compareTo (Object other)
   {
      OOVariable otherVariable = (OOVariable) other;

      int result = getFirstName().compareTo (otherVariable.getFirstName());

      if (result != 0)
      {
         return result;
      }

      result = getType().compareTo (otherVariable.getType());

      if (result != 0)
      {
         return result;
      }

      return getSecondName().compareTo (otherVariable.getSecondName());
   }


   /**
    * Get the sourceCode attribute of the OOVariable object
    *
    * @param visitor  No description provided
    * @return         The sourceCode value
    */
   public String getSourceCode (OOGenVisitor visitor)
   {
      return visitor.getSourceCode (this);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOVariable[" + this.firstName + "," + this.type + "," + this.secondName + "]";
   }
}

/*
 * $Log: OOVariable.java,v $
 * Revision 1.15  2004/10/20 17:49:35  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
