/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;
import java.util.LinkedList;


/**
 * <h2> Associations </h2> <pre>
 *             0..1      hasStatements      n
 * OOGenToken -------------------------------- OOStatement
 *             token   {ordered,}   statement
 * </pre>
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.15 $
 */
public abstract class OOStatement
{
   /**
    * Default Constructor
    */
   public OOStatement() { }


   /**
    * Get the sourceCode attribute of the OOStatement object
    *
    * @param visitor  No description provided
    * @return         The sourceCode value
    */
   public abstract String getSourceCode (OOGenVisitor visitor);


   /**
    * <pre>
    *             0..1      hasStatements      n
    * OOGenToken -------------------------------- OOStatement
    *             token   {ordered,}   statement
    * </pre>
    */
   private OOGenToken token;


   /**
    * UMLMethod: '+ setToken (value: OOGenToken): Boolean'.
    *
    * @param value  The new token value
    * @return       No description provided
    */
   public boolean setToken (OOGenToken value)
   {
      boolean changed = false;
      if (this.token != value)
      {
         if (this.token != null)
         {
            OOGenToken oldValue = this.token;
            this.token = null;
            oldValue.removeFromStatement (this);
         }
         this.token = value;
         if (value != null)
         {
            value.addToStatement (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getToken (): OOGenToken'.
    *
    * @return   The token value
    */
   public OOGenToken getToken()
   {
      return this.token;
   }


   /**
    * UMLMethod: '+ removeYou (): Void'.
    */
   public void removeYou()
   {
      OOGenToken tmpToken = getToken();
      if (tmpToken != null)
      {
         setToken (null);
      } // if
   }

   //
   // tools section
   //

   /**
    * append all <code>statements</code> to <code>theLinkedList</code>
    *
    * @param theLinkedList  a <code>LinkedList</code> value
    * @param statements     The object added.
    */
   public static void addAll (LinkedList theLinkedList, OOStatement statements[])
   {
      for (int i = 0; i < statements.length; i++)
      {
         theLinkedList.add (statements[i]);
      }
   }


   /**
    * copy contents of <code>theList</code> to an array
    *
    * @param theList  a <code>LinkedList</code> value
    * @return         an <code>OOStatement[]</code> value
    */
   public static OOStatement[] toArray (LinkedList theList)
   {
      OOStatement result[] = new OOStatement[theList.size()];

      System.arraycopy (theList.toArray(), 0,
         result, 0, theList.size());

      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theList       No description provided
    * @param newStatement  No description provided
    */
   public static void add (LinkedList theList, OOStatement newStatement)
   {
      theList.add (newStatement);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theList    No description provided
    * @param theObject  No description provided
    */
   public static void add (LinkedList theList, Object theObject)
   {
      if (theObject instanceof OOStatement)
      {
         theList.add (theObject);
      }
      else if (theObject instanceof LinkedList)
      {
         theList.addAll ((LinkedList) theObject);
      }
      else
      {
         throw new IllegalArgumentException ("theObject=" + theObject);
      }
   }


   /**
    * Access method for an one to n association.
    *
    * @param theList  The object added.
    * @param iter     The object added.
    */
   public static void addAll (LinkedList theList, Iterator iter)
   {
      while (iter.hasNext())
      {
         theList.add (iter.next());
      }
   }


   /**
    * Describe <code>toString</code> method here.
    *
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOStatement[]";
   }
}

/*
 * $Log: OOStatement.java,v $
 * Revision 1.15  2004/10/20 17:49:34  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
