/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * UMLClass: 'OOPrefixExpr'.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $ <h2>Associations</h2> <pre>
 *                               0..1
 * OOPrefixExpr ----------------------> OOExpression
 *                             myExpr
 * </pre>
 */
public class OOPrefixExpr extends OOSingleExpr
{
   /**
    * Constructor for class OOPrefixExpr
    */
   private OOPrefixExpr() { }


   /**
    * Constructor for class OOPrefixExpr
    *
    * @param theOp   No description provided
    * @param theExp  No description provided
    */
   public OOPrefixExpr (OOPrefixOp theOp, OOExpression theExp)
   {
      setMyOp (theOp);
      setMyExpr (theExp);
   }


   /**
    * UMLAttribute : 'myOp : OOPrefixOp '
    */
   private OOPrefixOp myOp;


   /**
    * Get the value of myOp.
    *
    * @return   Value of myOp.
    */
   public OOPrefixOp getMyOp()
   {
      return this.myOp;
   }


   /**
    * Set the value of myOp.
    *
    * @param myOp  Value to assign to myOp.
    */
   public void setMyOp (OOPrefixOp myOp)
   {
      if (this.myOp != myOp)
      {
         this.myOp = myOp;
      }
   }


   /**
    * <pre>
    *                               0..1
    * OOPrefixExpr ----------------------> OOExpression
    *                             myExpr
    * </pre>
    */
   private OOExpression myExpr;


   /**
    * @param value  The new myExpr value
    * @return       No description provided
    * @see          #myExpr
    */
   public boolean setMyExpr (OOExpression value)
   {
      if (this.myExpr != value)
      {
         this.myExpr = value;

         return true;
      }

      return false;
   }


   /**
    * @return   The myExpr value
    * @see      #myExpr
    */
   public OOExpression getMyExpr()
   {
      return this.myExpr;
   }


   /**
    * Get the sourceCode attribute of the OOPrefixExpr object
    *
    * @param visitor  No description provided
    * @return         The sourceCode value
    */
   public String getSourceCode (OOGenVisitor visitor)
   {
      return visitor.getSourceCode (this);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOPrefixExpr[" + this.myOp + "," + this.myExpr + "]";
   }
}

/*
 * $Log: OOPrefixExpr.java,v $
 * Revision 1.10  2004/10/20 17:49:34  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
