/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * UMLClass: 'OOInfixExprRight'.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $ <h2> Associations </h2> <pre>
 *                   0..1      hasNextExpression
 * OOInfixExprRight <--------------------------------------- OOInfixExprRight
 *                   nextExpression
 *
 *               0..1    hasExpression       0..1
 * OOExpression <--------------------------------- OOInfixExprRight
 *               myExp
 * </pre>
 */
public class OOInfixExprRight
{
   /**
    * Constructor for class OOInfixExprRight
    */
   private OOInfixExprRight() { }


   /**
    * Constructor for class OOInfixExprRight
    *
    * @param myOp   No description provided
    * @param myExp  No description provided
    */
   public OOInfixExprRight (OOInfixOp myOp, OOExpression myExp)
   {
      this.myOp = myOp;
      this.myExp = myExp;

      if (myExp == null)
      {
         throw new Error ("myExp is null !");
      }

   }


   /**
    * <pre>
    *                   0..1      hasNextExpression
    * OOInfixExprRight <--------------------------------------- OOInfixExprRight
    *                   nextExpression
    * </pre>
    */
   private OOInfixExprRight nextExpression;


   /**
    * UMLMethod: '+ getNextExpression (): OOInfixExprRight'.
    *
    * @return   The nextExpression value
    */
   public OOInfixExprRight getNextExpression()
   {
      return this.nextExpression;
   }


   /**
    * UMLMethod: '+ setNextExpression (value: OOInfixExprRight): Boolean'.
    *
    * @param value  The new nextExpression value
    * @return       No description provided
    */
   public boolean setNextExpression (OOInfixExprRight value)
   {
      boolean changed = false;
      if (this.nextExpression != value)
      {
         this.nextExpression = value;

         changed = true;
      }
      return changed;
   }


   /**
    * <pre>
    *               0..1    hasExpression       0..1
    * OOExpression <--------------------------------- OOInfixExprRight
    *               myExp
    * </pre>
    */
   private OOExpression myExp;


   /**
    * UMLMethod: '+ setExpression (value: OOMyExp): Boolean'.
    *
    * @param value  The new myExp value
    * @return       No description provided
    */
   public boolean setMyExp (OOExpression value)
   {
      boolean changed = false;
      if (this.myExp != value)
      {
         this.myExp = value;

         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getMyExp (): OOExpression'.
    *
    * @return   The myExp value
    */
   public OOExpression getMyExp()
   {
      return this.myExp;
   }


   /**
    * UMLAttribute : 'myOp : OOInfixOp '
    */
   private OOInfixOp myOp;


   /**
    * Get the value of myOp.
    *
    * @return   Value of myOp.
    */
   public OOInfixOp getMyOp()
   {
      return this.myOp;
   }


   /**
    * UMLMethod: '+ removeYou (): Void'.
    */
   public void removeYou()
   {
      OOExpression tmpMyExp = getMyExp();
      if (tmpMyExp != null)
      {
         setMyExp (null);
      } // if

      OOInfixExprRight tmpNextExpression = getNextExpression();
      if (tmpNextExpression != null)
      {
         setNextExpression (null);
      } // if

   }

}

/*
 * $Log: OOInfixExprRight.java,v $
 * Revision 1.10  2004/10/20 17:49:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
