/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * <h2> Associations </h2> <pre>
 *                   0..1   hasRightExpression
 * OOInfixExprRight <--------------------------------- OOInfixExprLeft
 *                   rightExp
 *
 *               0..1   hasLeftExpression   0..1
 * OOExpression --------------------------------- OOInfixExprLeft
 *               myExp          oOInfixExpLeft
 * </pre>
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public class OOInfixExprLeft extends OOExpression
{
   /**
    * Constructor for class OOInfixExprLeft
    *
    * @param theExpression  No description provided
    */
   public OOInfixExprLeft (OOExpression theExpression)
   {
      setMyExp (theExpression);

      if (theExpression == null)
      {
         new Error ("theExpression is null!");
      }

   }


   /**
    * Constructor for class OOInfixExprLeft
    */
   private OOInfixExprLeft() { }


   /**
    * <pre>
    *                   0..1   hasRightExpression
    * OOInfixExprRight <--------------------------------- OOInfixExprLeft
    *                   rightExp
    * </pre>
    */
   private OOInfixExprRight rightExp;


   /**
    * UMLMethod: '+ setRightExp (value: OOInfixExprRight): Boolean'.
    *
    * @param value  The new rightExp value
    * @return       No description provided
    */
   public boolean setRightExp (OOInfixExprRight value)
   {
      boolean changed = false;
      if (this.rightExp != value)
      {
         this.rightExp = value;

         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getRightExp (): OOInfixExprRight'.
    *
    * @return   The rightExp value
    */
   public OOInfixExprRight getRightExp()
   {
      return this.rightExp;
   }


   /**
    * <pre>
    *               0..1   hasLeftExpression   0..1
    * OOExpression --------------------------------- OOInfixExprLeft
    *               myExp          oOInfixExpLeft
    * </pre>
    */
   private OOExpression myExp;


   /**
    * UMLMethod: '+ setMyExp (value: OOExpression): Boolean'.
    *
    * @param value  The new myExp value
    * @return       No description provided
    */
   public boolean setMyExp (OOExpression value)
   {
      boolean changed = false;
      if (this.myExp != value)
      {
         this.myExp = value;

         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getMyExp (): OOExpression'.
    *
    * @return   The myExp value
    */
   public OOExpression getMyExp()
   {
      return this.myExp;
   }


   /**
    * UMLMethod: '+ removeYou (): Void'.
    */
   public void removeYou()
   {
      OOInfixExprRight tmpRightExp = getRightExp();
      if (tmpRightExp != null)
      {
         setRightExp (null);
      } // if

      OOExpression tmpMyExp = getMyExp();
      if (tmpMyExp != null)
      {
         setMyExp (null);
      } // if

      super.removeYou();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theOp  No description provided
    * @param expr   No description provided
    */
   public void append (OOInfixOp theOp, OOExpression expr)
   {
      if (theOp == null || expr == null)
      {
         throw new Error (this + ".append(" + theOp + "," + expr);
      }

      OOInfixExprRight oldRight = getRightExp();

      if (oldRight == null)
      {
         setRightExp (new OOInfixExprRight (theOp, expr));
      }
      else
      {
         OOInfixExprRight newRight = oldRight.getNextExpression();

         while (newRight != null)
         {
            oldRight = newRight;
            newRight = oldRight.getNextExpression();
         }

         oldRight.setNextExpression (new OOInfixExprRight (theOp, expr));
      }
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("OOInfixExpr[");
      result.append (this.myExp);

      OOInfixExprRight tmpRight = getRightExp();

      while (tmpRight != null)
      {
         result.append (",");
         result.append (tmpRight.getMyOp());
         result.append (",");
         result.append (tmpRight.getMyExp());

         tmpRight = tmpRight.getNextExpression();
      }

      result.append ("]");

      return result.toString();
   }


   /**
    * Get the sourceCode attribute of the OOInfixExprLeft object
    *
    * @param visitor  No description provided
    * @return         The sourceCode value
    */
   public String getSourceCode (OOGenVisitor visitor)
   {
      return visitor.getSourceCode (this);
   }

}

/*
 * $Log: OOInfixExprLeft.java,v $
 * Revision 1.12  2004/10/20 17:49:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
