/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * Class OOActivityCodeGenHandler
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.18 $
 */
public abstract class OOGenStrategyHandler extends CodeGenStrategyHandler
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String AT_POST_VARIABLE = "atPostVariable";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String COLLAB_STAT_BEGIN = "collabStatBegin";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String COLLAB_STAT_END = "collabStatEnd";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FIND_LOWER_BOUND_ELSE_CLAUSE = "findLowerBoundElseClause";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FIND_LOWER_BOUND_ELSE_IF_CLAUSE = "findLowerBoundElseIfClause";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FIND_LOWER_BOUND_IF_CLAUSE = "findLowerBoundIfClause";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String I_MULTILINK_SEARCH_NORM_BOTTOM = "iMultiLinkSearchNormBottom";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String I_MULTILINK_SEARCH_NORM_TOP = "iMultiLinkSearchNormTop";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String I_MULTILINK_SEARCH_OPTIONAL_BOTTOM = "iMultiLinkSearchOptionalBottom";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String I_MULTILINK_SEARCH_OPTIONAL_TOP = "iMultiLinkSearchOptionalTop";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String I_MULTILINK_SEARCH_SET = "iMultiLinkSearchSet";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ISOMORPHIC_BINDING = "isomorphicBinding";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ISOMORPHIC_BINDING_BODY = "isomorphicBindingBody";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ISOMORPHIC_BINDING_SET = "isomorphicBindingSet";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_CHECK_BETWEEN_SETS = "linkCheckBetweenSets";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_CHECK_TO_MANY = "linkCheckToMany";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_CHECK_TO_ONE = "linkCheckToOne";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_CHECK_TO_SET = "linkCheckToSet";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_CREATE = "linkCreate";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_CREATE_SET = "linkCreateSet";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_CREATE_SET_TOP = "linkCreateSetTop";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_DELETE = "linkDelete";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_DELETE_SET = "linkDeleteSet";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_SEARCH_TO_MANY_TOP = "linkSearchToManyTop";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_SEARCH_TO_MANY_BOTTOM = "linkSearchToManyBottom";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_SEARCH_TO_ONE = "linkSearchToOne";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_SEARCH_TO_SET_TOP = "linkSearchToSetTop";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LINK_SEARCH_TO_SET_BOTTOM = "linkSearchToSetBottom";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MULTILINK_CHECK = "multiLinkCheck";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MULTILINK_CHECK_FIRST = "multiLinkCheckFirst";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MULTILINK_CHECK_LAST = "multiLinkCheckLast";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MULTILINK_INSERT_OBJECT = "multiLinkInsertObject";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MULTILINK_SEARCH_BOUND_TO_UNBOUND = "multiLinkSearchBoundToUnBound";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MULTILINK_SEARCH_UNBOUND_TO_BOUND = "multiLinkSearchUnboundToBound";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MULTILINK_SEARCH_FIRST = "multiLinkSearchFirst";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MULTILINK_SEARCH_LAST = "multiLinkSearchLast";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String OBJECT_CREATE = "objectCreate";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String OBJECT_DELETE = "objectDelete";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PRECONDITION_CHECK = "preconditionCheck";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STORY_DIAGRAM_BOTTOM = "storyDiagramBottom";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STORY_DIAGRAM_TOP = "storyDiagramTop";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String TYPE_CAST = "typeCast";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String UML_ATTR_EXPR_PAIR = "umlAttrExprPair";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String RETURN_STAT = "returnStatement";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PATH_EXPR_CREATE = "pathExprCreate";


   /**
    * Default Constructor
    */
   public OOGenStrategyHandler()
   {
      super();
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOGenStrategyHandler[]";
   }
}

/*
 * $Log: OOGenStrategyHandler.java,v $
 * Revision 1.18  2004/10/20 17:49:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
