/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.LinkedList;
import java.util.StringTokenizer;

import de.uni_paderborn.fujaba.metamodel.*;


/**
 * Class OOGenStrategyClient
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.56 $ <h2> Associations </h2> <pre>
 *                      0..1          0..1
 * OOGenStrategyClient -------------------- OOGenStrategyHandler
 *                      client     handler
 *
 *                      0..1           0..1
 * OOGenStrategyClient --------------------- OOGenFunction
 *                      client     function
 * </pre>
 */
public class OOGenStrategyClient
    extends CodeGenStrategy
{
   /**
    * Default Constructor
    */
   public OOGenStrategyClient() { }


   /**
    * generate sourcecode for complete <code>FProject theProject</code>
    *
    * @param theProject  the given <code>FProject</code>
    */
   public final void generateFProject (FProject theProject)
   {
      handlerGenerate (theProject, null, null);
   }


   /**
    * generate sourcecode for given <code>FPackage</code> and all existing subpackages
    *
    * @param thePackage  the given <code>FPackage</code>
    */
   public final void generateFPackage (FPackage thePackage)
   {
      handlerGenerate (thePackage, null, null);
   }


   //
   // begin method flow section
   //

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public OOStatement[] methodFlowForEachStart()
   {
      return new OOStatement[]{OO.startBlock(), OO.lineComment (" for each flow")};
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public OOStatement[] methodFlowForEachEnd()
   {
      return new OOStatement[]{OO.endBlock (" end for each flow")};
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comment    No description provided
    * @param condition  No description provided
    * @return           No description provided
    */
   public OOStatement[] methodFlowWhileHead (String comment, OOExpression condition)
   {
      LinkedList statements = new LinkedList();

      if (comment != null)
      {
         OOStatement.add (statements, OO.lineComment (comment));
      }

      statements.add (OO.whileStat (condition));
      OOStatement.add (statements, OO.startBlock());

      return OOStatement.toArray (statements);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comment  No description provided
    * @return         No description provided
    */
   public OOStatement[] methodFlowDo (String comment)
   {
      LinkedList statements = new LinkedList();

      if (comment != null)
      {
         OOStatement.add (statements, OO.lineComment (comment));
      }

      OOStatement.add (statements, new OODoStatement());
      OOStatement.add (statements, OO.startBlock());

      return OOStatement.toArray (statements);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param condition  No description provided
    * @return           No description provided
    */
   public OOStatement[] methodFlowWhileFoot (OOExpression condition)
   {
      return new OOStatement[]{OO.endBlock(), OO.whileStat (condition, true)};
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comment  No description provided
    * @param expr     No description provided
    * @return         No description provided
    */
   public OOStatement[] methodFlowIfThen (String comment, OOExpression expr)
   {
      LinkedList statements = new LinkedList();

      if (comment != null)
      {
         OOStatement.add (statements, OO.lineComment (comment));
      }

      OOStatement.add (statements, OO.ifStat (expr));
      OOStatement.add (statements, OO.startBlock());

      return OOStatement.toArray (statements);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public OOStatement[] methodFlowElse()
   {
      return new OOStatement[]{new OOElseStatement(), OO.startBlock()};
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param positive  No description provided
    * @return          No description provided
    */
   public OOExpression methodFlowCondition (boolean positive)
   {
      OOExpression result = OO.identifier (OO.variable (OOVariableType.iFujabaSuccess));

      if (!positive)
      {
         result = OO.not (result);
      }

      return result;
   }

   //
   // end method flow section
   //

   //
   // begin isomorphic binding section
   //

   /**
    * Describe constant <code>HL_SDM</code> here.
    */
   public final static int HL_SDM = 10;


   /**
    * Describe <code>hideEnabled</code> method here.
    *
    * @return   a <code>boolean</code> value
    */
   public boolean hideEnabled()
   {
      return false;
   }


   /**
    * Describe <code>openHideTag</code> method here.
    *
    * @param nr  an <code>int</code> value
    * @return    an <code>OOStatement[]</code> value
    */
   public OOStatement[] openHideTag (int nr)
   {
      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" openHideTag(" + nr + ") is missing !"));

      return OOStatement.toArray (statements);
   }


   /**
    * Describe <code>closeHideTag</code> method here.
    *
    * @return   an <code>OOStatement[]</code> value
    */
   public OOStatement[] closeHideTag()
   {
      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment ("closeHideTag() is missing !"));

      return OOStatement.toArray (statements);
   }


   /**
    * Describe <code>setInternalVariables</code> method here.
    *
    * @param modifiedSetItems  a <code>boolean</code> value
    * @return                  an <code>OOStatement[]</code> value
    */
   public OOStatement[] setInternalVariables (boolean modifiedSetItems)
   {
      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.fujabaSuccess (OOIdentifierExpr.TRUE_IDENTIFIER));

      return OOStatement.toArray (statements);
   }


   /**
    * Describe <code>constraintText</code> method here.
    *
    * @param condition   an <code>OOExpression</code> value
    * @param assertStmt  No description provided
    * @return            an <code>OOStatement[]</code> value
    */
   public OOStatement[] constraintText (OOExpression condition, boolean assertStmt)
   {
      return constraintTextWithComment (condition, "constraint", assertStmt);
   }


   /**
    * Describe <code>constraintText</code> method here.
    *
    * @param condition   a <code>String</code> value
    * @param assertStmt  No description provided
    * @return            an <code>OOStatement[]</code> value
    */
   public OOStatement[] constraintText (String condition, boolean assertStmt)
   {
      return constraintTextWithComment (condition, "constraint", assertStmt);
   }


   /**
    * Describe <code>constraintTextWithComment</code> method here.
    *
    * @param condition   an <code>OOExpression</code> value
    * @param comment     a <code>String</code> value
    * @param assertStmt  No description provided
    * @return            an <code>OOStatement[]</code> value
    */
   public OOStatement[] constraintTextWithComment (OOExpression condition, String comment, boolean assertStmt)
   {
      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (comment));
      if (assertStmt)
      {
         OOStatement.add (statements, OO.assertStmt (condition, comment));
      }
      else
      {
         OOStatement.add (statements, OO.ensure (condition));
      }
      OOStatement.add (statements, OO.emptyLine());

      return OOStatement.toArray (statements);
   }


   /**
    * Describe <code>constraintTextWithComment</code> method here.
    *
    * @param condition   a <code>String</code> value
    * @param comment     a <code>String</code> value
    * @param assertStmt  No description provided
    * @return            an <code>OOStatement[]</code> value
    */
   public OOStatement[] constraintTextWithComment (String condition, String comment, boolean assertStmt)
   {
      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (comment));
      if (assertStmt)
      {
         OOStatement.add (statements, OO.assertStmt (condition, comment));
      }
      else
      {
         OOStatement.add (statements, OO.ensure (condition));
      }
      OOStatement.add (statements, OO.emptyLine());

      return OOStatement.toArray (statements);
   }


   /**
    * Describe <code>memoField</code> method here.
    *
    * @param code  a <code>String</code> value
    * @return      an <code>OOStatement[]</code> value
    */
   public OOStatement[] memoField (String code)
   {
      LinkedList statements = new LinkedList();

      // split the text in lines
      // work around the string tokenizer
      int countDelimiters = 0;

      // split the text in lines
      // work around the string tokenizer
      int
         minIndent = Integer.MAX_VALUE;

      // split the text in lines
      // work around the string tokenizer
      int
         curIndent = 0;

      // split the text in lines
      // work around the string tokenizer
      int
         i = 0;
      char tmpChar;
      boolean end;
      StringTokenizer st = new StringTokenizer (code, "\n", true);

      while (st.hasMoreTokens())
      {
         String strg = st.nextToken();

         if (strg.equals ("\n"))
         {
            countDelimiters++;
         }
         else
         {
            countDelimiters = 0;
         }

         if ( (strg.length() >= 1) &&  (!strg.equals ("\n")))
         {
            // count the whitespaces in front of the text
            if (strg.trim().length() > 1)
            {
               curIndent = 0;
               end = false;
               for (i = 0; !end && i < strg.length(); i++)
               {
                  tmpChar = strg.charAt (i);
                  if (tmpChar == ' ')
                  {
                     curIndent++;
                  }
                  else if (tmpChar == '\t')
                  {
                     curIndent += 4;
                  }
                  else
                  {
                     end = true;
                  }
               }
               minIndent = Math.min (curIndent, minIndent);
            }
         }
      }

      // check if there was something wrong in calculating the indent
      if (minIndent == Integer.MAX_VALUE)
      {
         minIndent = 0;
      }

      st = new StringTokenizer (code, "\n", true);
      countDelimiters = 0;
      while (st.hasMoreTokens())
      {
         String strg = st.nextToken();

         if (strg.equals ("\n"))
         {
            countDelimiters++;
         }
         else
         {
            countDelimiters = 0;
         }

         if ( (strg.length() >= 1) &&  (!strg.equals ("\n")))
         {
            OOStatement.add (statements, new OOMemoStatement (strg));
         }
      }

      return OOStatement.toArray (statements);
   }

   //
   // generate section
   //

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theClass  No description provided
    * @return          No description provided
    */
   public String generateImportClass (FClass theClass)
   {
      return getCurrentOOGenVisitor().generateImportClass (theClass);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param thePackage  No description provided
    * @return            No description provided
    */
   public String generateImportPackage (FPackage thePackage)
   {
      return getCurrentOOGenVisitor().generateImportPackage (thePackage);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public void generateFPackageBegin (FFile theFile)
   {
      getCurrentOOGenVisitor().generatePackageBegin (theFile);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public void generateFPackageEnd (FFile theFile)
   {
      getCurrentOOGenVisitor().generatePackageEnd (theFile);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void generateClassStartBlock()
   {
      getCurrentOOGenVisitor().generateClassStartBlock();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void generateClassEndBlock()
   {
      getCurrentOOGenVisitor().generateClassEndBlock();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void newLine()
   {
      getCurrentOOGenVisitor().newLine();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param blockType  No description provided
    */
   public void generateOpenBlock (String blockType)
   {
      getCurrentOOGenVisitor().generateOpenBlock (blockType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param blockType  No description provided
    */
   public void generateCloseBlock (String blockType)
   {
      getCurrentOOGenVisitor().generateCloseBlock (blockType);
   }

   //
   // create section
   //

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param blockType  No description provided
    * @return           No description provided
    */
   public String createOpenBlock (String blockType)
   {
      return getCurrentOOGenVisitor().createOpenBlock (blockType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param blockType  No description provided
    * @return           No description provided
    */
   public String createCloseBlock (String blockType)
   {
      return getCurrentOOGenVisitor().createCloseBlock (blockType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theClass  No description provided
    * @return          No description provided
    */
   public String createInterfaceDeclaration (FClass theClass)
   {
      return getCurrentOOGenVisitor().createInterfaceDeclaration (theClass);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theClass  No description provided
    * @return          No description provided
    */
   public String createClassDeclaration (FClass theClass)
   {
      return getCurrentOOGenVisitor().createClassDeclaration (theClass);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theCommentary  No description provided
    * @return               No description provided
    */
   public String createFClassCommentary (FCommentary theCommentary)
   {
      return getCurrentOOGenVisitor().createClassCommentary (theCommentary);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theCommentary  No description provided
    * @return               No description provided
    */
   public String createFAttrCommentary (FCommentary theCommentary)
   {
      return getCurrentOOGenVisitor().createAttrCommentary (theCommentary);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theCommentary  No description provided
    * @return               No description provided
    */
   public String createFMethodCommentary (FCommentary theCommentary)
   {
      return getCurrentOOGenVisitor().createMethodCommentary (theCommentary);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theClass  No description provided
    * @return          No description provided
    */
   public String createFClassInterfaceModifier (FClass theClass)
   {
      return getCurrentOOGenVisitor().createClassInterfaceModifier (theClass);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theAttr  No description provided
    * @return         No description provided
    */
   public String createFAttrDeclaration (FAttr theAttr)
   {
      return getCurrentOOGenVisitor().createAttrDeclaration (theAttr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theMethod  No description provided
    * @return           No description provided
    */
   public String createFMethodDeclaration (FMethod theMethod)
   {
      return getCurrentOOGenVisitor().createMethodDeclaration (theMethod);
   }

   //
   // append section
   //

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comment  No description provided
    */
   public void appendFClassCommentary (String comment)
   {
      getCurrentOOGenVisitor().appendClassCommentary (comment);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param declString  No description provided
    */
   public void appendFClassDeclaration (String declString)
   {
      getCurrentOOGenVisitor().appendClassDeclaration (declString);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param decl  No description provided
    */
   public void appendFAttrDeclaration (String decl)
   {
      getCurrentOOGenVisitor().appendAttrDeclaration (decl);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comment  No description provided
    */
   public void appendFAttrCommentary (String comment)
   {
      getCurrentOOGenVisitor().appendAttrCommentary (comment);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theCommentary  No description provided
    */
   public void appendFMethodCommentary (String theCommentary)
   {
      getCurrentOOGenVisitor().appendMethodCommentary (theCommentary);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param decl  No description provided
    */
   public void appendFMethodDeclaration (String decl)
   {
      getCurrentOOGenVisitor().appendMethodDeclaration (decl);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param body  No description provided
    */
   public void appendFMethodBody (String body)
   {
      getCurrentOOGenVisitor().appendMethodBody (body);
      newLine();
      newLine();
   }


   //
   // get identifier, keywords, literals etc.
   //

   /**
    * Get the interfaceName attribute of the OOGenStrategyClient object
    *
    * @param theClass  No description provided
    * @return          The interfaceName value
    */
   public String getInterfaceName (FClass theClass)
   {
      return getCurrentOOGenVisitor().getInterfaceName (theClass);
   }


   /**
    * Get the className attribute of the OOGenStrategyClient object
    *
    * @param theClass  No description provided
    * @return          The className value
    */
   public String getClassName (FClass theClass)
   {
      return getCurrentOOGenVisitor().getClassName (theClass);
   }


   /**
    * Get the attrDeclName attribute of the OOGenStrategyClient object
    *
    * @param theAttr  No description provided
    * @return         The attrDeclName value
    */
   public String getAttrDeclName (FAttr theAttr)
   {
      return getCurrentOOGenVisitor().getAttrDeclName (theAttr);
   }


   /**
    * Get the methodDeclName attribute of the OOGenStrategyClient object
    *
    * @param theMethod  No description provided
    * @return           The methodDeclName value
    */
   public String getMethodDeclName (FMethod theMethod)
   {
      return getCurrentOOGenVisitor().getMethodDeclName (theMethod);
   }


   /**
    * Get the progLangType attribute of the OOGenStrategyClient object
    *
    * @param theType  No description provided
    * @return         The progLangType value
    */
   public String getProgLangType (FBaseTypes theType)
   {
      return getCurrentOOGenVisitor().getProgLangType (theType);
   }


   /**
    * Get the uMLAttrDeclVisibilityString attribute of the OOGenStrategyClient object
    *
    * @param theAttr  No description provided
    * @return         The uMLAttrDeclVisibilityString value
    */
   public String getFAttrDeclVisibilityString (FAttr theAttr)
   {
      return getCurrentOOGenVisitor().getAttrDeclVisibilityString (theAttr.getVisibility());
   }


   /**
    * Get the uMLMethodDeclVisibilityString attribute of the OOGenStrategyClient object
    *
    * @param theMethod  No description provided
    * @return           The uMLMethodDeclVisibilityString value
    */
   public String getFMethodDeclVisibilityString (FMethod theMethod)
   {
      return getCurrentOOGenVisitor().getMethodDeclVisibilityString (theMethod.getVisibility());
   }


   /**
    * Get the visibilityString attribute of the OOGenStrategyClient object
    *
    * @param theDeclaration  No description provided
    * @return                The visibilityString value
    */
   public String getVisibilityString (FDeclaration theDeclaration)
   {
      return getCurrentOOGenVisitor().getVisibilityString (theDeclaration.getVisibility());
   }


   /**
    * Get the visibilityString attribute of the OOGenStrategyClient object
    *
    * @param visibility  No description provided
    * @return            The visibilityString value
    */
   public String getVisibilityString (int visibility)
   {
      return getCurrentOOGenVisitor().getVisibilityString (visibility);
   }

   //
   // the rest
   //

   /**
    * Get the currentOOGenVisitor attribute of the OOGenStrategyClient object
    *
    * @return   The currentOOGenVisitor value
    */
   public OOGenVisitor getCurrentOOGenVisitor()
   {
      return (OOGenVisitor) getCurrentVisitor();
   }

   //
   // end delegation section
   //

   /**
    * Describe <code>toString</code> method here.
    *
    * @return   short string representation of current object
    */

   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("OOGenStrategyClient[name=");
      result.append (getName());
      result.append (",visitor=");
      result.append (getCurrentOOGenVisitor());
      result.append ("]");

      return result.toString();
   }
}

/*
 * $Log: OOGenStrategyClient.java,v $
 * Revision 1.56  2004/10/29 13:46:52  lowende
 * Some improvements for parsed code
 *
 */
