/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Vector;

import org.apache.log4j.Logger;


/**
 * UMLClass: 'OOExpression'.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.16 $
 */
public abstract class OOExpression
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (OOExpression.class);


   /**
    * UMLMethod: '+ removeYou (): Void'.
    */
   public void removeYou()
   {
      log.error (this + ".removeYou() is not implemented !");
   }

   // create some expressions

   /**
    * Access method for an one to n association.
    *
    * @param theVector   The object added.
    * @param expression  The object added.
    */
   public static void addAll (Vector theVector, OOExpression expression[])
   {
      for (int i = 0; i < expression.length; i++)
      {
         theVector.add (expression[i]);
      }
   }


   /**
    * copy contents of <code>theVector</code> to an array
    *
    * @param theVector  a <code>Vector</code> value
    * @return           an <code>OOExpression[]</code> value
    */
   public static OOExpression[] toArray (Vector theVector)
   {
      OOExpression result[] = new OOExpression[theVector.size()];

      System.arraycopy (theVector.toArray(), 0,
         result, 0, theVector.size());

      return result;
   }

   // create text
   /**
    * Get the sourceCode attribute of the OOExpression object
    *
    * @param visitor  No description provided
    * @return         The sourceCode value
    */
   public String getSourceCode (OOGenVisitor visitor)
   {
      return this + ".getSourceCode() not implemented !";
   }

}

/*
 * $Log: OOExpression.java,v $
 * Revision 1.16  2004/10/20 17:49:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
