/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class OOCaseStatement
    extends OOStatement
{
   /**
    * Default Constructor
    *
    * @param value       No description provided
    * @param statements  No description provided
    */
   public OOCaseStatement (String value, Vector statements)
   {
      Set set = new HashSet();
      set.add (value);
      setValues (set.iterator());
      setStatements (statements);
   }


   /**
    * Constructor for class OOCaseStatement
    *
    * @param values      No description provided
    * @param statements  No description provided
    */
   public OOCaseStatement (Iterator values, Vector statements)
   {
      setValues (values);
      setStatements (statements);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Iterator values;


   /**
    * Sets the values attribute of the OOCaseStatement object
    *
    * @param values  The new values value
    */
   public void setValues (Iterator values)
   {
      this.values = values;
   }


   /**
    * Get the values attribute of the OOCaseStatement object
    *
    * @return   The values value
    */
   public Iterator getValues()
   {
      return values;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector statements;


   /**
    * Sets the statements attribute of the OOCaseStatement object
    *
    * @param statements  The new statements value
    */
   public void setStatements (Vector statements)
   {
      this.statements = statements;
   }


   /**
    * Get the statements attribute of the OOCaseStatement object
    *
    * @return   The statements value
    */
   public Vector getStatements()
   {
      return statements;
   }


   /**
    * Get the sourceCode attribute of the OOCaseStatement object
    *
    * @param visitor  No description provided
    * @return         The sourceCode value
    */
   public String getSourceCode (OOGenVisitor visitor)
   {
      return visitor.getSourceCode (this);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOCaseStatement[]";
   }
}

/*
 * $Log: OOCaseStatement.java,v $
 * Revision 1.8  2004/10/20 17:49:32  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
