/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;


/**
 * Class MultiLinkSearchLastOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15.2.5 $
 */
public class MultiLinkSearchLastOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (MultiLinkSearchLastOOFunction.class);


   /**
    * Default Constructor
    */
   public MultiLinkSearchLastOOFunction() { }


   /**
    * Get the responsible attribute of the MultiLinkSearchLastOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.MULTILINK_SEARCH_LAST.equals (methodName);
   }


   /**
    * MultiLink: bind the object with the last element of the containter Describe <code>generateOOCode</code>
    * method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String objectName;
      FType objectType;
      String objectTypeStr;
      String containerObjectName;
      String containerName;
      String className;

      // parse param
      try
      {
         objectName = (String) param[0];
         objectType = (FType) param[1];
         objectTypeStr = (String) param[2];
         containerObjectName = (String) param[3];
         containerName = (String) param[4];
         className = (String) param[5];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".multiLinkSearchLast("
            + "objectName=" + objectName
            + ",objectType=" + objectType
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            + ",className=" + className
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" multiLink bind " +
         objectName +
         " : " + objectType +
         " multiLinkSearchLast is empty !"));

      boolean typeCastNeeded = !objectType.getName().equals (className);
      if (!typeCastNeeded)
      {
         OOLocalVarDeclStatement objectVar = objectType == null ?
            OO.varDecl (objectTypeStr, objectName,
            OO.typeCast (objectType,
            OO.call (containerObjectName,
            OO.method (containerName,
            OOMethodType.GET_LAST_OF_METHOD)))) :
            OO.varDecl (objectType, objectName,
            OO.typeCast (objectType,
            OO.call (containerObjectName,
            OO.method (containerName,
            OOMethodType.GET_LAST_OF_METHOD))));
         OOStatement.add (statements, objectVar);

         OOStatement.add (statements, OO.ensure (OO.notNullExpr (objectName)));
      }
      else
      {
         OOStatement.add (statements, OO.varDecl ("Object", OOVariable.FUJABA_TMP_OBJECT,
            OO.call (containerObjectName, OO.method (containerName,
            OOMethodType.GET_LAST_OF_METHOD))));

         OOStatement.add (statements,
            OO.ensure (
            OO.infixOp (
            OO.notNullExpr (OOVariable.FUJABA_TMP_OBJECT),
            OOInfixOp.AND_OP,
            new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT, objectTypeStr))));

         OOLocalVarDeclStatement objectVar = objectType == null ?
            OO.varDecl (objectTypeStr, objectName,
            OO.typeCast (objectType, OOVariable.FUJABA_TMP_OBJECT)) :
            OO.varDecl (objectType, objectName,
            OO.typeCast (objectType, OOVariable.FUJABA_TMP_OBJECT));
         OOStatement.add (statements, objectVar);
      }

//      for (int i = 0; i < umlAttrValuePairs.length; i++)
//      {
//         OOStatement.add (statements, OO.exprStat (umlAttrValuePairs[i]));
//      }

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "MultiLinkSearchLastOOFunction[]";
   }
}

/*
 * $Log: MultiLinkSearchLastOOFunction.java,v $
 * Revision 1.15.2.5  2005/12/15 16:20:41  lowende
 * Removed a few compile warnings.
 *
 */
