/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;


/**
 * Class MultiLinkInsertObjectOOFunction
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.15.2.2 $
 */
public class MultiLinkInsertObjectOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (MultiLinkInsertObjectOOFunction.class);


   /**
    * Default Constructor
    */
   public MultiLinkInsertObjectOOFunction() { }


   /**
    * Get the responsible attribute of the MultiLinkInsertObjectOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.MULTILINK_INSERT_OBJECT.equals (methodName);
   }


   /**
    * insert Object into container Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String newObject;
      String newObjectType;
      String leftObject;
      String rightObject;
      boolean hasCreateModifier;
      int context;
      String containerObjectName;
      String containerName;

      try
      {
         newObject = (String) param[0];
         newObjectType = (String) param[1];
         leftObject = (String) param[2];
         rightObject = (String) param[3];
         hasCreateModifier =  ((Boolean) param[4]).booleanValue();
         context =  ((Integer) param[5]).intValue();
         containerObjectName = (String) param[6];
         containerName = (String) param[7];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".multiLinkInsertObject("
            + "newObject=" + newObject
            + ",newObjectType=" + newObjectType
            + ",leftObject=" + leftObject
            + ",rightObject=" + rightObject
            + ",hasCreateModifier=" + hasCreateModifier
            + ",context=" + context
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            );
      }

      LinkedList statements = new LinkedList();

      StringBuffer comment = new StringBuffer();

      /*
       *  tringBuffer result = new StringBuffer ();
       *  StringBuffer indexName = new StringBuffer ();
       */
      // comment
      comment.append (" insert ");
      comment.append (newObject);
      comment.append (" : ");
      comment.append (newObjectType);
      if (context <= UMLMultiLink.C_LEFT_NULL)
      {
         comment.append (" after ");
         comment.append (leftObject);
      }
      else if (context > UMLMultiLink.C_LEFT_NULL)
      {
         comment.append (" before ");
         comment.append (rightObject);
      }

      OOStatement.add (statements, OO.lineComment (comment.toString() + " multiLinkInsertObject is empty !"));

      if (hasCreateModifier)
      {
         OO.assignStat (OO.variable (newObject), OO.newObject (newObjectType));
      }

      if ( (context == UMLMultiLink.C_LEFT_OPTIONAL) ||  (context == UMLMultiLink.C_LEFT_SET) ||
          (context == UMLMultiLink.C_RIGHT_OPTIONAL) ||  (context == UMLMultiLink.C_RIGHT_SET))
      {
         OOVariable object = null;
         if ( (context == UMLMultiLink.C_LEFT_OPTIONAL) ||  (context == UMLMultiLink.C_LEFT_SET))
         {
            object = OO.variable (leftObject);
         }
         else
         {
            object = OO.variable (rightObject);
         }

         if ( (context == UMLMultiLink.C_LEFT_SET) ||  (context == UMLMultiLink.C_RIGHT_SET))
         {
            //result.append("!");
            OOStatement.add (statements, OO.ifStat (OO.not (OO.call (object,
               OO.method ("isEmpty()")))));
         }
         else
         {
            OOStatement.add (statements, OO.ifStat (OO.notNullExpr (object)));
         }

         OOStatement.add (statements, OO.startBlock());
      }
      else if ( (context == UMLMultiLink.C_LEFT_CREATE_OBJECT) ||
          (context == UMLMultiLink.C_LEFT_CREATE_LINK))
      {
         OOStatement.add (statements, OO.ifStat (OO.call (containerObjectName,
            OO.method (containerName, OOMethodType.HAS_IN_METHOD),
            OO.identifier (leftObject))));
         OOStatement.add (statements, OO.startBlock());
      }

      if (context < UMLMultiLink.C_LEFT_NULL)
      {
         OOCallMethodExpr sourceMethod = OO.call (containerObjectName,
            OO.method (containerName, OOMethodType.ADD_AFTER_OF_METHOD),
            OO.identifier (leftObject));

         sourceMethod.addToParameter (OO.identifier (newObject));

         OOStatement.add (statements, OO.exprStat (sourceMethod));
      }
      else if (context > UMLMultiLink.C_LEFT_NULL)
      {
         OOCallMethodExpr sourceMethod = OO.call (containerObjectName,
            OO.method (containerName, OOMethodType.ADD_BEFORE_OF_METHOD),
            OO.identifier (rightObject));

         sourceMethod.addToParameter (OO.identifier (newObject));

         OOStatement.add (statements, OO.exprStat (sourceMethod));
      }
      else
      {
         OOCallMethodExpr sourceMethod = OO.call (containerObjectName,
            OO.method (containerName, OOMethodType.ADD_METHOD));

         UMLMultiLink link = (UMLMultiLink) incr;
         if ( (link.getType() == UMLMultiLink.FIRST) ||  ( (link.getPreviousMultiLink() != null)
            &&  (link.getPreviousMultiLink().getType() == UMLMultiLink.FIRST)))
         {
            sourceMethod.addToParameter (OO.identifier ("0"));
         }
         sourceMethod.addToParameter (OO.identifier (newObject));
         OOStatement.add (statements, OO.exprStat (sourceMethod));

      }

      // if left or right object is optional or set; or if left or right object has create modifier
      if ( (context == UMLMultiLink.C_LEFT_OPTIONAL) ||  (context == UMLMultiLink.C_LEFT_SET) ||
          (context == UMLMultiLink.C_RIGHT_OPTIONAL) ||  (context == UMLMultiLink.C_RIGHT_SET) ||
          (context == UMLMultiLink.C_LEFT_CREATE_OBJECT) ||  (context == UMLMultiLink.C_LEFT_CREATE_LINK))
      {
         OOStatement.add (statements, OO.endBlock ("fi"));
      }

      return statements;
      /*
       *  / if left or right object is optional or set
       *  if ((context == UMLMultiLink.C_LEFT_OPTIONAL) || (context == UMLMultiLink.C_LEFT_SET) ||
       *  (context == UMLMultiLink.C_RIGHT_OPTIONAL) || (context == UMLMultiLink.C_RIGHT_SET))
       *
       *  {
       *  result.append(newLine()).append("if (");
       *  if ((context == UMLMultiLink.C_LEFT_SET) || (context == UMLMultiLink.C_RIGHT_SET))
       *
       *  {
       *  result.append("!");
       *  }
       *  if ((context == UMLMultiLink.C_LEFT_OPTIONAL) || (context == UMLMultiLink.C_LEFT_SET))
       *
       *  {
       *  result.append(leftObject);
       *  }
       *  else
       *
       *  {
       *  result.append(rightObject);
       *  }
       *  if ((context == UMLMultiLink.C_LEFT_SET) || (context == UMLMultiLink.C_RIGHT_SET))
       *
       *  {
       *  result.append(".isEmpty())");
       *  }
       *  else
       *
       *  {
       *  result.append(" != null)");
       *  }
       *  result.append(openBlockBracket());
       *  incIndent();
       *  }
       *  / if left or right object has a create modifier
       *  if ((context == UMLMultiLink.C_LEFT_CREATE_OBJECT) || (context == UMLMultiLink.C_LEFT_CREATE_LINK))
       *
       *  {
       *  result.append(newLine()).append("if (").append(containerObjectName);
       *  result.append(getAccessMethodName(containerName, HAS_IN_METHOD));
       *  result.append("(").append(leftObject).append("))");
       *  result.append(openBlockBracket());
       *  incIndent();
       *  }
       *  if (context < UMLMultiLink.C_LEFT_NULL)
       *
       *  {
       *  result.append(newLine()).append(containerObjectName).append(".addAfterOf").append(CGU.upFirstChar(containerName));
       *  result.append(" (").append(leftObject).append(", ").append(newObject).append(");\n");
       *  }
       *  else if (context > UMLMultiLink.C_LEFT_NULL)
       *
       *  {
       *  result.append(newLine()).append(containerObjectName).append(".addBeforeOf").append(CGU.upFirstChar(containerName));
       *  result.append(" (").append(rightObject).append(", ").append(newObject).append(");\n");
       *  }
       *  else
       *
       *  {
       *  result.append(newLine()).append(containerObjectName).append(".addTo").append(CGU.upFirstChar(containerName));
       *  result.append(" (").append(newObject).append(");\n");
       *  }
       *  / if left or right object is optional or set; or if left or right object has create modifier
       *  if ((context == UMLMultiLink.C_LEFT_OPTIONAL) || (context == UMLMultiLink.C_LEFT_SET) ||
       *  (context == UMLMultiLink.C_RIGHT_OPTIONAL) || (context == UMLMultiLink.C_RIGHT_SET) ||
       *  (context == UMLMultiLink.C_LEFT_CREATE_OBJECT) || (context == UMLMultiLink.C_LEFT_CREATE_LINK))
       *
       *  {
       *  decIndent();
       *  result.append(closeBlockBracket("if"));
       *  }
       *  else
       *
       *  {
       *  result.append("\n");
       *  }
       *  return result.toString();
       */
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "MultiLinkInsertObjectOOFunction[]";
   }
}

/*
 * $Log: MultiLinkInsertObjectOOFunction.java,v $
 * Revision 1.15.2.2  2005/05/02 11:51:04  creckord
 * Fix for Multilinks
 * Small change in CoObRA change filtering
 *
 */
