/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class MultiLinkCheckOOFunction
 *
 * @author    $Author: l3_g5 $
 * @version   $Revision: 1.16.2.1 $
 */
public class MultiLinkCheckOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (MultiLinkCheckOOFunction.class);


   /**
    * Default Constructor
    */
   public MultiLinkCheckOOFunction() { }


   /**
    * Get the responsible attribute of the MultiLinkCheckOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.MULTILINK_CHECK.equals (methodName);
   }


   /**
    * Bound -> Bound Search for all check multilinks Describe <code>generateOOCode</code> method
    * here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      UMLMultiLink link = (UMLMultiLink) incr;
      String sourceObjectName;
      int umlSourceType;
      String targetObjectName;
      int umlTargetType;
      String objectType;
      String containerObjectName;
      String containerName;
      int multiLinkType;
      int index;

      try
      {
         sourceObjectName = (String) param[0];
         umlSourceType =  ((Integer) param[1]).intValue();
         targetObjectName = (String) param[2];
         umlTargetType =  ((Integer) param[3]).intValue();
         objectType = (String) param[4];
         containerObjectName = (String) param[5];
         containerName = (String) param[6];
         multiLinkType =  ((Integer) param[7]).intValue();
         index =  ((Integer) param[8]).intValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".multiLinkCheck("
            + "sourceObjectName=" + sourceObjectName
            + ",umlSourceType=" + umlSourceType
            + ",targetObjectName=" + targetObjectName
            + ",umlTargetType=" + umlTargetType
            + ",objectType=" + objectType
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            + ",multiLinkType=" + multiLinkType
            + ",index=" + index
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" check multilink " + sourceObjectName +
         " to " + targetObjectName));

      OOExpression source = null;
      OOExpression target = null;
      OOExpression optSourceExpr = null;
      OOExpression optTargetExpr = null;
      OOExpression conditionExpr = null;
      OOInfixExprLeft tmpLeftExpr = null;
      OOCallMethodExpr sourceMethod = null;

      //      SourceCodeFactory factory = UMLProject.getSourceCodeFactory ();

      //      result.append (newLine ()).append ("// check multilink ").append (sourceObjectName);
      //result.append (" to ").append (targetObjectName).append ("\n");

      if (umlSourceType == UMLObject.SET)
      {
         //	 source.append ("(").append (objectType).append (") ").append (sourceObjectName).append (".last()");
         source = OO.typeCast (objectType,
            OO.call (sourceObjectName, "last"));
      }
      else
      {
         //	 source.append (sourceObjectName);
         source = OO.identifier (sourceObjectName);
      }

      if (umlTargetType == UMLObject.SET)
      {
         //	 target.append ("(").append (objectType).append (") ").append (targetObjectName).append (".first()");
         target = OO.typeCast (objectType,
            OO.call (targetObjectName, "first"));
      }
      else
      {
         //	 target.append (targetObjectName);
         target = OO.identifier (targetObjectName);
      }

      //      result.append (newLine ()).append ("JavaSDM.ensure (");

      if ( (umlSourceType == UMLObject.OPTIONAL) ||  (umlSourceType == UMLObject.SET))
      {
         //	 result.append (sourceObjectName).append (" == null || ");
         optSourceExpr = OO.isNullExpr (sourceObjectName);
      }

      if ( (umlTargetType == UMLObject.OPTIONAL) ||  (umlTargetType == UMLObject.SET))
      {
         optTargetExpr = OO.isNullExpr (targetObjectName);

         if (optSourceExpr != null)
         {
            tmpLeftExpr = OO.infixOp (optSourceExpr, OOInfixOp.OR_OP, optTargetExpr);
         }
      }
      else
      {
         optTargetExpr = optSourceExpr;
      }

      if ( (umlSourceType == UMLObject.SET) ||  (umlTargetType == UMLObject.SET) ||  (multiLinkType == UMLMultiLink.INDIRECT))
      {
         //   result.append (containerObjectName).append (".").append (factory.getAccessMethodName (containerName, factory.IS_BEFORE_OF_METHOD));
         //  	 result.append (" (").append (source).append (", ").append (target).append (closeNormBracket ());
         sourceMethod = OO.call (containerObjectName,
            OO.method (containerName, OOMethodType.IS_BEFORE_OF_METHOD));
         sourceMethod.addToParameter (source);
         sourceMethod.addToParameter (target);
      }
      else if (multiLinkType == UMLMultiLink.DIRECT)
      {
         //   result.append (containerObjectName).append (".").append (factory.getAccessMethodName (containerName, factory.GET_NEXT_OF_METHOD));
         //  	 result.append (" (").append (source);
         //  	 result.append (").equals").append ("(").append (target);
         //  	 result.append (")");
         sourceMethod = OO.call (containerObjectName,
            OO.method (containerName, OOMethodType.GET_NEXT_OF_METHOD),
            source);
         sourceMethod = OO.call (targetObjectName, OOMethod.EQUALS_METHOD, sourceMethod);
      }
      else if (multiLinkType == UMLMultiLink.INDEX)
      {
         //   result.append (containerObjectName).append (".").append (factory.getAccessMethodName (containerName, factory.GET_NEXT_INDEX_OF_METHOD));
         //  	 result.append (" (").append (source).append (", ").append (index).append (").equals").append ("(");
         //  	 result.append (target).append (")");
         sourceMethod = OO.call (containerObjectName,
            OO.method (containerName, OOMethodType.GET_NEXT_INDEX_OF_METHOD));
         sourceMethod.addToParameter (source);
         sourceMethod.addToParameter (OO.identifier (Integer.toString (index)));
         sourceMethod = OO.call (targetObjectName, OOMethod.EQUALS_METHOD, sourceMethod);
      }

      if (tmpLeftExpr != null)
      {
         tmpLeftExpr.append (OOInfixOp.OR_OP, sourceMethod);
         conditionExpr = tmpLeftExpr;
      }
      else if (optTargetExpr != null)
      {
         conditionExpr = OO.infixOp (optTargetExpr, OOInfixOp.OR_OP, sourceMethod);
      }
      else
      {
         conditionExpr = sourceMethod;
      }

      if (link.isAssertInUnitTest())
      {
         OOStatement.add (statements, OO.assertStmt (conditionExpr, "check multilink " + sourceObjectName +
            " to " + targetObjectName));
      }
      else
      {
         OOStatement.add (statements, OO.ensure (conditionExpr));
      }
      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "MultiLinkCheckOOFunction[]";
   }
}

/*
 * $Log: MultiLinkCheckOOFunction.java,v $
 * Revision 1.16.2.1  2005/11/18 10:57:49  l3_g5
 * attribute assertions for multilinks work
 *
 */
