/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.LinkedList;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * @author    lowende
 * @version   $Revision: 1.7.2.1 $ $Date: 2005/08/23 08:24:41 $
 */
public class LinkSearchToSetBottomOOFunction extends OOGenFunction
{

   /**
    * @param methodName  No description provided
    * @return            The responsible value
    * @see               de.uni_paderborn.fujaba.codegen.CodeGenFunction#isResponsible(java.lang.String)
    */
   public boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_SEARCH_TO_SET_BOTTOM.equals (methodName);
   }


   /**
    * @param asgElement  No description provided
    * @param methodName  No description provided
    * @param param       No description provided
    * @return            No description provided
    * @see               de.uni_paderborn.fujaba.codegen.CodeGenFunction#generateCode(de.uni_paderborn.fujaba.metamodel.FElement,
    *      java.lang.String, java.lang.Object[])
    */
   public Object generateCode (FElement asgElement, String methodName, Object[] param)
   {
      UMLLink umlLink = (UMLLink) asgElement;
      UMLObject targetObject = umlLink.getTarget();

      // the target object must be the set
      if (!targetObject.isSet())
      {
         // the source object must be the set
         targetObject = umlLink.getSource();
      }

      String targetObjectType = targetObject.getObjectType();
      LinkedList statements = new LinkedList();

      // don't collect elements of sets to be deleted
      if (! (targetObject.getModifier() == UMLObject.DELETE && targetObject.isSet()))
      {
         // add temporal variable to set
         OOVariable tmpVar = OO.variable (targetObjectType, OOVariableType.iFujabaTmpObject);
         OOStatement.add (statements, OO.exprStat (OO.call (CGU.downFirstChar (targetObject.getObjectName()),
            OOMethod.ADD_TO_SET_METHOD, OO.identifier (tmpVar))));
      }

      // end of try block
      OOStatement.add (statements, OO.endBlock());

      // catch statement
      OOStatement.add (statements, OO.catchStat (OOExceptionExpr.SDM_EXCEPTION,
         OO.variable (OOVariableType.iBreakExceptionVariable)));
      OOStatement.add (statements, OO.startBlock());
      OOStatement.add (statements, OO.endBlock());

      // end of while block
      OOStatement.add (statements, OO.endBlock ("while"));

      return statements;
   }

}

/*
 * $Log: LinkSearchToSetBottomOOFunction.java,v $
 * Revision 1.7.2.1  2005/08/23 08:24:41  lowende
 * Removed compile warnings.
 *
 */
