/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;


/**
 * Class LinkSearchToOneOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.26.2.2 $
 */
public class LinkSearchToOneOOFunction
    extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkSearchToOneOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkSearchToOneOOFunction() { }


   /**
    * Get the responsible attribute of the LinkSearchToOneOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_SEARCH_TO_ONE.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public Object generateCode (FElement incr, String methodName, Object param[])
   {
      String sourceObjectName;
      FType sourceObjectType;
      String sourceRoleName;
      String targetObjectName;
      String targetObjectTypeStr;
      FType targetObjectType;
      String targetRoleName;
      String className;
      boolean targetOptional;
      boolean soQualifierKey;
      boolean toQualifierKey;
      String range;

      // parse params
      try
      {
         sourceObjectName = (String) param[0];
         sourceObjectType = (FType) param[1];
         sourceRoleName = (String) param[3];
         targetObjectName = (String) param[4];
         targetObjectType = (FType) param[5];
         targetObjectTypeStr = (String) param[6];
         targetRoleName = (String) param[7];
         className = (String) param[8];
         targetOptional =  ((Boolean) param[9]).booleanValue();
         soQualifierKey =  ((Boolean) param[10]).booleanValue();
         toQualifierKey =  ((Boolean) param[11]).booleanValue();
         range = (String) param[12];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkSearchToOne("
            + "sourceObjectName=" + sourceObjectName
            + ",sourceObjectType=" + sourceObjectType
            + ",sourceRoleName=" + sourceRoleName
            + ",targetObjectName=" + targetObjectName
            + ",targetObjectType=" + targetObjectType
            + ",targetRoleName=" + targetRoleName
            + ",className=" + className
            + ",targetOptional=" + targetOptional
            + ",soQualifierKey=" + soQualifierKey
            + ",toQualifierKey=" + toQualifierKey
            + ",range=" + range
            );
      }

      LinkedList statements = new LinkedList();

      OOExpression sourceExpr = null;
      OOExpression tmpCondition = null;

      OOInfixExprLeft tmpLeftExpr = null;
      OOCallMethodExpr tmpCallMethodExpr = null;
      OOVariable targetVar = null;
      OOType targetVarType = null;

      OOStatement.add (statements, OO.lineComment ("bind " + targetObjectName + ": " + targetObjectTypeStr));

      boolean targetTypeCastNeeded = !targetObjectTypeStr.equals (className);

      OOVariable realTargetVar = OO.variable (targetObjectName);
      OOType realTargetVarType;
      if (targetObjectType != null)
      {
         realTargetVarType = OO.type (targetObjectType);
      }
      else
      {
         realTargetVarType = OO.type (targetObjectTypeStr);
      }
      if (!targetTypeCastNeeded)
      {
         targetVar = realTargetVar;
         targetVarType = realTargetVarType;
      }
      else
      {
         targetVar = OO.variable (OOVariableType.iFujabaTmpObject);
         targetVarType = OO.type ("Object");
      }

      if (soQualifierKey)
      {
         sourceExpr = OO.call (OO.variable (sourceObjectName),
            OO.method (sourceRoleName,
            OOMethodType.GET_FROM_METHOD),
            OO.identifier (range));
      }
      else
      {
         sourceExpr = OO.call (OO.variable (sourceObjectName), OO.method (sourceRoleName, OOMethodType.GET_METHOD));
      }

      OOStatement.add (statements, OO.varDecl (targetVarType, targetVar, sourceExpr));

      if (!targetTypeCastNeeded)
      {
         if (!targetOptional)
         {
            tmpCondition = OO.notNullExpr (targetObjectName);
            OOStatement.add (statements, OO.ensure (tmpCondition));
         }
      }
      else
      {
         tmpLeftExpr = OO.notNullExpr (OO.variable (OOVariableType.iFujabaTmpObject));
         tmpCondition = new OOObjectOfTypeExpr (OO.variable (OOVariableType.iFujabaTmpObject), targetObjectTypeStr);
         tmpCondition = OO.infixOp (tmpLeftExpr, OOInfixOp.AND_OP, tmpCondition);
         if (!targetOptional)
         {
            OOStatement.add (statements, OO.ensure (tmpCondition));
         }
         else
         {
            OOStatement.add (statements, OO.ifStat (tmpCondition));
            OOStatement.add (statements, OO.startBlock());
         }

         OOStatement.add (statements, OO.varDecl (realTargetVarType,
            realTargetVar,
             (targetObjectType == null ? OO.typeCast (targetObjectTypeStr,
            OO.variable (OOVariableType.iFujabaTmpObject)) :
            OO.typeCast (targetObjectType,
            OO.variable (OOVariableType.iFujabaTmpObject)))));

         if (targetOptional)
         {
            OOStatement.add (statements, OO.endBlock ("typecast cast"));
         }
      }

      if (toQualifierKey && !soQualifierKey)
      {
         OOStatement.add (statements, OO.lineComment ("check Reverse-Qualified-Link '" +
            targetRoleName + "' between " +
            targetObjectName + " and " +
            sourceObjectName));

         tmpCallMethodExpr = OO.call (OO.variable (targetObjectName), OO.method (targetRoleName, OOMethodType.HAS_IN_METHOD));
         tmpCallMethodExpr.addToParameter (OO.identifier (range));
         tmpCallMethodExpr.addToParameter (OO.identifier (sourceObjectName));

         if (targetOptional)
         {
            tmpLeftExpr = OO.isNullExpr (targetObjectName);
            tmpCondition = OO.infixOp (tmpLeftExpr, OOInfixOp.OR_OP, tmpCallMethodExpr);
         }
         else
         {
            tmpCondition = tmpCallMethodExpr;
         }

         OOStatement.add (statements, OO.ensure (tmpCondition));
      }

      OOStatement.add (statements, OO.emptyLine());
      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkSearchToOneOOFunction[]";
   }
}

/*
 * $Log: LinkSearchToOneOOFunction.java,v $
 * Revision 1.26.2.2  2005/08/23 08:24:42  lowende
 * Removed compile warnings.
 *
 */
