/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;



/**
 * Class LinkSearchToManyTopOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.31.2.2 $
 */
public class LinkSearchToManyTopOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkSearchToManyTopOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkSearchToManyTopOOFunction() { }


   /**
    * Get the responsible attribute of the LinkSearchToManyTopOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_SEARCH_TO_MANY_TOP.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public Object generateCode (FElement incr,
                               String methodName,
                               Object param[])
   {
      String sourceObjectName;
      FType sourceObjectType;
      String sourceRoleName;
      String targetObjectName;
      FType targetObjectType;
      String targetObjectTypeStr;
      String targetRoleName;
      String className;
      boolean targetOptional;
      boolean targetSet;
      boolean forEach;
      boolean sourceQualifierKey;
      boolean targetQualifierKey;
      String range;

      // parse param
      try
      {
         sourceObjectName = (String) param[0];
         sourceObjectType = (FType) param[1];
         sourceRoleName = (String) param[3];
         targetObjectName = (String) param[4];
         targetObjectType = (FType) param[5];
         targetObjectTypeStr = (String) param[6];
         targetRoleName = (String) param[7];
         className = (String) param[8];
         targetOptional =  ((Boolean) param[9]).booleanValue();
         targetSet =  ((Boolean) param[10]).booleanValue();
         forEach =  ((Boolean) param[11]).booleanValue();
         sourceQualifierKey =  ((Boolean) param[12]).booleanValue();
         targetQualifierKey =  ((Boolean) param[13]).booleanValue();
         range = (String) param[14];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkSearchToManyTop("
            + "sourceObjectName=" + sourceObjectName
            + ",sourceObjectType=" + sourceObjectType
            + ",sourceRoleName=" + sourceRoleName
            + ",targetObjectName=" + targetObjectName
            + ",targetObjectType=" + targetObjectType
            + ",targetRoleName=" + targetRoleName
            + ",className=" + className
            + ",targetOptional=" + targetOptional
            + ",targetSet=" + targetSet
            + ",forEach=" + forEach
            + ",sourceQualifierKey=" + sourceQualifierKey
            + ",targetQualifierKey=" + targetQualifierKey
            + ",range=" + range);
      }

      LinkedList statements = new LinkedList();

      OOExpression conditionExpr = null;
      OOExpression notFujabaSuccess = null;
      OOCallMethodExpr iteratorMethodExpr = null;
      OOFWIteratorHasNextExpr hasNextExpr = null;
      OOCallMethodExpr hasInMethodExpr = null;

      OOStatement.add (statements, OO.lineComment ("bind " + targetObjectName + ": " + targetObjectTypeStr));

      String uniqueName = CGU.upFirstChar (sourceObjectName) + CGU.upFirstChar (sourceRoleName) + CGU.upFirstChar (targetObjectName);
      OOVariable iterName = OO.variable (uniqueName.toString(), OOVariableType.iFujabaIter);

      iteratorMethodExpr = OO.call (sourceObjectName, OO.method (sourceRoleName, OOMethodType.ITERATOR_OF_METHOD));

      if (sourceQualifierKey)
      {
         iteratorMethodExpr.addToParameter (OO.identifier (range));
      }

      OOStatement.add (statements, OO.varDecl ("FWIterator", iterName, iteratorMethodExpr));

      if (targetOptional)
      {
         OOStatement.add (statements, new OODoStatement());
      }
      else
      {
         hasNextExpr = OO.iterHasNext (iterName, sourceObjectName, OO.type (sourceRoleName), true);
         if (!forEach)
         {
            notFujabaSuccess = OO.not (OO.identifier (OOVariableType.iFujabaSuccess));
            conditionExpr = OO.infixOp (notFujabaSuccess, OOInfixOp.AND_OP, hasNextExpr);
         }
         else
         {
            conditionExpr = hasNextExpr;
         }

         OOStatement.add (statements, OO.whileStat (conditionExpr));
      }

      OOStatement.add (statements, OO.startBlock());
      OOStatement.add (statements, new OOTryStatement());
      OOStatement.add (statements, OO.startBlock());

      OOVariable realTargetVar = OO.variable (targetObjectName);
      OOType realTargetVarType;
      if (targetObjectType != null)
      {
         realTargetVarType = OO.type (targetObjectType);
      }
      else
      {
         realTargetVarType = OO.type (targetObjectTypeStr);
      }

      if (targetOptional)
      {
         OOStatement.add (statements, OO.varDecl (realTargetVarType, realTargetVar, OOIdentifierExpr.NULL_IDENTIFIER));
         OOStatement.add (statements, OO.ifStat (OO.iterHasNext (iterName, sourceObjectName)));
         OOStatement.add (statements, OO.startBlock());
      }

      if (targetObjectTypeStr.equals (className))
      {
         OOStatement.add (statements, OO.varDecl (realTargetVarType, realTargetVar,
             (targetObjectType == null ? OO.typeCast (targetObjectTypeStr, OO.iterGet (iterName)) :
            OO.typeCast (targetObjectType, OO.iterGet (iterName)))));
         OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iterName)));
         OOStatement.add (statements, OO.emptyLine());
      }
      else
      {
         OOStatement.add (statements, OO.varDecl (OO.type ("Object"), OO.variable (OOVariableType.iFujabaTmpObject), OO.iterGet (iterName)));

         if (targetOptional)
         {
            OOStatement.add (statements, OO.ifStat (new OOObjectOfTypeExpr (OOVariableType.iFujabaTmpObject, targetObjectTypeStr)));
            OOStatement.add (statements, OO.startBlock());
            OOStatement.add (statements, OO.assignStat (targetObjectName,  (targetObjectType == null ?
               OO.typeCast (targetObjectTypeStr, OOVariableType.iFujabaTmpObject) :
               OO.typeCast (targetObjectType, OOVariableType.iFujabaTmpObject))));
            OOStatement.add (statements, OO.endBlock());
            OOStatement.add (statements, new OOElseStatement());
            OOStatement.add (statements, OO.startBlock());
            OOStatement.add (statements, OO.ensure (OO.not (OO.iterHasNext (iterName, sourceObjectName))));
            OOStatement.add (statements, OO.endBlock());
         }
         else
         {
            OOStatement.add (statements, OO.ensure (new OOObjectOfTypeExpr (OOVariableType.iFujabaTmpObject, targetObjectTypeStr)));
            OOStatement.add (statements, OO.varDecl (realTargetVarType, realTargetVar,  (targetObjectType == null ?
               OO.typeCast (targetObjectTypeStr, OOVariableType.iFujabaTmpObject) :
               OO.typeCast (targetObjectType, OOVariableType.iFujabaTmpObject))));
            OOStatement.add (statements, OO.emptyLine());
         }
      }

      if (targetOptional)
      {
         OOStatement.add (statements, OO.endBlock());
         OOStatement.add (statements, OO.emptyLine());
      }

      if (targetQualifierKey && !sourceQualifierKey)
      {
         OOStatement.add (statements, OO.lineComment ("check Reverse-Qualified-Link '" +
            targetRoleName + "' between " + targetObjectName +
            " and " + sourceObjectName));

         hasInMethodExpr = OO.call (targetObjectName, OO.method (targetRoleName, OOMethodType.HAS_IN_METHOD));
         hasInMethodExpr.addToParameter (OO.identifier (range));
         hasInMethodExpr.addToParameter (OO.identifier (sourceObjectName));

         if (targetOptional)
         {
            conditionExpr = OO.infixOp (OO.isNullExpr (targetObjectName), OOInfixOp.OR_OP, hasInMethodExpr);
         }
         else
         {
            conditionExpr = hasInMethodExpr;
         }

         OOStatement.add (statements, OO.ensure (conditionExpr));
         OOStatement.add (statements, OO.emptyLine());
      }

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkSearchToManyTopOOFunction[]";
   }
}

/*
 * $Log: LinkSearchToManyTopOOFunction.java,v $
 * Revision 1.31.2.2  2005/08/23 08:24:41  lowende
 * Removed compile warnings.
 *
 */
