/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * Class LinkCheckBetweenSetsOOFunction
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
public class LinkCheckBetweenSetsOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkCheckBetweenSetsOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkCheckBetweenSetsOOFunction() { }


   /**
    * Get the responsible attribute of the LinkCheckBetweenSetsOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_CHECK_BETWEEN_SETS.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String sourceRole;
      String targetRole;
      String sourceObjectName;
      String sourceObjectType;
      String targetObjectName;
      String targetObjectType;
      boolean totality;
      boolean linkNegative;

      try
      {
         sourceRole = (String) param[0];
         targetRole = (String) param[1];
         sourceObjectName = (String) param[2];
         sourceObjectType = (String) param[3];
         targetObjectName = (String) param[4];
         targetObjectType = (String) param[5];
         totality =  ((Boolean) param[6]).booleanValue();
         linkNegative =  ((Boolean) param[7]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkCheckBetweenSets("
            + "sourceRole=" + sourceRole
            + ",targetRole=" + targetRole
            + ",sourceObjectName=" + sourceObjectName
            + ",sourceObjectType=" + sourceObjectType
            + ",targetObjectName=" + targetObjectName
            + ",targetObjectType=" + targetObjectType
            + ",totality=" + totality
            + ",linkNegative=" + linkNegative
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" link between set '" + sourceObjectName +
         "' and '" + targetObjectName + " linkCheckBetweenSets"));

      if (totality)
      {
         statements.add (OO.lineComment (" totality enabled: every object linked with every object"));
      }
      else
      {
         statements.add (OO.lineComment (" totality disabled: object linked with at least another object"));
      }

      OOStatement.addAll (statements,
         linkCheckOneSide (targetRole,
         sourceObjectName,
         sourceObjectType,
         targetObjectName,
         targetObjectType,
         totality,
         linkNegative));
      OOStatement.addAll (statements,
         linkCheckOneSide (sourceRole,
         targetObjectName,
         targetObjectType,
         sourceObjectName,
         sourceObjectType,
         totality,
         linkNegative));

      //  result.append (newLine ()).append (CGU.downFirstChar (sourceObjectName)).append (" = ").append ("new");
      //  	result.append (CGU.upFirstChar (sourceObjectName)).append ("Set;\n");
      //  	result.append (newLine ()).append (CGU.downFirstChar (targetObjectName)).append (" = ").append ("new");
      //  	result.append (CGU.upFirstChar (targetObjectName)).append ("Set;\n");

      return statements;
   }


   /**
    * Describe <code>linkCheckOneSide</code> method here.
    *
    * @param roleName          a <code>String</code> value
    * @param sourceObjectName  a <code>String</code> value
    * @param sourceObjectType  a <code>String</code> value
    * @param targetObjectName  a <code>String</code> value
    * @param targetObjectType  a <code>String</code> value
    * @param totality          a <code>boolean</code> value
    * @param linkNegative      a <code>boolean</code> value
    * @return                  an <code>OOStatement[]</code> value
    */
   private OOStatement[] linkCheckOneSide (String roleName,
                                           String sourceObjectName,
                                           String sourceObjectType,
                                           String targetObjectName,
                                           String targetObjectType,
                                           boolean totality,
                                           boolean linkNegative)
   {
      throw new UnsupportedOperationException ("please send your fpr-file to mksoft@upb.de !");
      /*
       *  StringBuffer result = new StringBuffer ();
       *  StringBuffer setSourceName = new StringBuffer ().append (CGU.downFirstChar (sourceObjectName));
       *  StringBuffer setTargetName = new StringBuffer ().append (CGU.downFirstChar (targetObjectName));
       *  StringBuffer iteratorSourceName = new StringBuffer ().append (getIntVarName (iFujabaIter)).append (CGU.upFirstChar (sourceObjectName));
       *  StringBuffer iteratorTargetName = new StringBuffer ().append (getIntVarName (iFujabaIter)).append (CGU.upFirstChar (targetObjectName)).append ("GoodObject");
       *  StringBuffer newSet = new StringBuffer ().append ("new").append (CGU.upFirstChar (sourceObjectName)).append ("Set");
       *  StringBuffer tmpSourceName = new StringBuffer ().append (getIntVarName (iFujabaTmpObject)).append (sourceObjectType);
       *  StringBuffer tmpTargetName = new StringBuffer ().append (getIntVarName (iFujabaTmpObject)).append (targetObjectType);
       *  result.append (newLine ()).append (newSet).append (" = new TreeSet").append (openNormBracket ());
       *  result.append ("new StandardComparator").append (openNormBracket ()).append (closeNormBracket ());
       *  result.append (closeNormBracket ()).append (";\n");
       *  result.append (newLine ()).
       *  append ("Iterator ").
       *  append (iteratorSourceName).
       *  append (" = ").
       *  append (setSourceName).
       *  append (".iterator");
       *  result.append (openNormBracket ()).append (closeNormBracket ()).append (";\n");
       *  result.append (newLine ()).append ("while ").append (openNormBracket ()).append (iteratorSourceName);
       *  result.append (".hasNext").append (openNormBracket ()).append (closeNormBracket ());
       *  result.append (closeNormBracket ()).append (openBlockBracket ());
       *  incIndent ();
       *  result.append (newLine ()).append (sourceObjectType).append (" ").append (tmpSourceName).append (" = ");
       *  result.append (openNormBracket ()).append (sourceObjectType).append (closeNormBracket ()).append (iteratorSourceName);
       *  result.append (".next").append (openNormBracket ()).append (closeNormBracket ()).append (";\n");
       *  if (totality)
       *  {
       *  result.append (newLine ()).append ("goodObject = true;\n");
       *  }
       *  else
       *  {
       *  result.append (newLine ()).append ("goodObject = false;\n");
       *  }
       *  result.append (newLine ()).
       *  append ("Iterator ").
       *  append (iteratorTargetName).
       *  append (" = ").
       *  append (setTargetName).
       *  append (".iterator");
       *  result.append (openNormBracket ()).append (closeNormBracket ()).append (";\n");
       *  result.append (newLine ()).append ("while ").append (openNormBracket ());
       *  if (!totality)
       *  {
       *  result.append ("!");
       *  }
       *  result.append ("goodObject && ").append (iteratorTargetName);
       *  result.append (".hasNext").append (openNormBracket ()).append (closeNormBracket ());
       *  result.append (closeNormBracket ()).append (openBlockBracket ());
       *  incIndent ();
       *  result.append (newLine ()).append (targetObjectType).append (" ").append (tmpTargetName).append (" = ");
       *  result.append (openNormBracket ()).append (targetObjectType).append (closeNormBracket ()).append (iteratorTargetName);
       *  result.append (".next").append (openNormBracket ()).append (closeNormBracket ()).append (";\n");
       *  result.append (newLine ()).append ("if ").append (openNormBracket ());
       *  if (totality)
       *  {
       *  result.append ("!");
       *  }
       *  result.append (tmpSourceName);
       *  result.append (".").append (getAccessMethodName (roleName, HAS_IN_METHOD)).append (openNormBracket ());
       *  result.append (tmpTargetName).append (closeNormBracket ()).append (closeNormBracket ());
       *  result.append (openBlockBracket ());
       *  incIndent ();
       *  if (totality)
       *  {
       *  result.append (newLine ()).append ("goodObject = false;\n");
       *  }
       *  else
       *  {
       *  result.append (newLine ()).append ("goodObject = true;\n");
       *  }
       *  decIndent ();
       *  result.append (closeBlockBracket ("if"));
       *  decIndent ();
       *  result.append (closeBlockBracket ("while"));
       *  result.append (newLine ()).append ("if ").append (openNormBracket ());
       *  if (linkNegative)
       *  {
       *  result.append ("!");
       *  }
       *  result.append ("goodObject").append (closeNormBracket ()).append (openBlockBracket ());
       *  incIndent ();
       *  result.append (newLine ()).append (newSet).append (".add").append (openNormBracket ());
       *  result.append (tmpSourceName).append (closeNormBracket ()).append (";\n");
       *  decIndent ();
       *  result.append (closeBlockBracket ("if"));
       *  decIndent ();
       *  result.append (closeBlockBracket ("while"));
       *  return result;
       */
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkCheckBetweenSetsOOFunction[]";
   }
}

/*
 * $Log: LinkCheckBetweenSetsOOFunction.java,v $
 * Revision 1.13  2004/10/20 17:49:31  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
