/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.HashSet;


/**
 * @author    mm
 * @version   $Revision: 1.2 $ $Date: 2004/10/20 17:49:37 $
 */
public class JavaChecker
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final String[] javaKeywords = {
      "abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue",
      "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto",
      "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package",
      "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized",
      "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HashSet javaKeywordsSet;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static JavaChecker instance;


   /**
    * Constructor for class JavaChecker
    */
   private JavaChecker()
   {
      createJavaKeywordsSet();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static JavaChecker get()
   {
      if (instance == null)
      {
         instance = new JavaChecker();
      }
      return instance;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void createJavaKeywordsSet()
   {
      javaKeywordsSet = new HashSet();

      for (int i = 0; i < javaKeywords.length; i++)
      {
         javaKeywordsSet.add (javaKeywords[i]);
      }
   }


   /**
    * checks if the given string is a valid Java identifier.
    *
    * @param name  the string to be checked
    * @return      true if the given string is a valid Java identifier, false otherwise.
    */
   public boolean isValidJavaIdentifier (String name)
   {
      boolean valid = true;

      if (name.length() > 0)
      {
         char[] chars = name.toCharArray();
         valid = Character.isJavaIdentifierStart (chars[0]);
         for (int i = 1; i < chars.length; i++)
         {
            if (!Character.isJavaIdentifierPart (chars[i]))
            {
               valid = false;
            }
         }
      }
      else
      {
         valid = false;
      }

      if (valid)
      { // check if name is a java keyword

         valid = !javaKeywordsSet.contains (name);
      }

      return valid;
   }
}

/*
 * $Log: JavaChecker.java,v $
 * Revision 1.2  2004/10/20 17:49:37  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
