/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * Class IsmorphicBindingBodyOOFunction
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public class IsomorphicBindingBodyOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (IsomorphicBindingBodyOOFunction.class);


   /**
    * Default Constructor
    */
   public IsomorphicBindingBodyOOFunction() { }


   /**
    * Get the responsible attribute of the IsomorphicBindingBodyOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.ISOMORPHIC_BINDING_BODY.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>OOExpression</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String newObjectName;
      String curObjectName;
      boolean curOptional;
      boolean curSet;

      // parse param
      try
      {
         newObjectName = (String) param[0];
         curObjectName = (String) param[1];
         curOptional =  ((Boolean) param[2]).booleanValue();
         curSet =  ((Boolean) param[3]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".isomorphicBindingBody(" +
            "newObjectName=" + newObjectName +
            ",curObjectName=" + curObjectName +
            ",curOptional=" + curOptional +
            ",curSet=" + curSet + ")");
      }

      OOExpression resultExpr = null;
      OOExpression curSetExpr = null;

      if (curSet)
      {
         curSetExpr = OO.not (OO.call (curObjectName,
            OOMethod.SET_CONTAINS_METHOD,
            OO.identifier (newObjectName)));
      }
      else
      {
         curSetExpr = OO.not (OO.call (curObjectName,
            OOMethodType.EQUALS_METHOD,
            OO.identifier (newObjectName)));
      }

      if (curOptional)
      {
         resultExpr = OO.infixOp (OO.isNullExpr (curObjectName), OOInfixOp.OR_OP, curSetExpr);
      }
      else
      {
         resultExpr = curSetExpr;
      }

      return resultExpr;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "IsmorphicBindingBodyOOFunction[]";
   }
}

/*
 * $Log: IsomorphicBindingBodyOOFunction.java,v $
 * Revision 1.12  2004/10/20 17:49:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
