/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;


/**
 * Class IMultiLinkSearchSetOOFunction
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.14.2.1 $
 */
public class IMultiLinkSearchSetOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (IMultiLinkSearchSetOOFunction.class);


   /**
    * Default Constructor
    */
   public IMultiLinkSearchSetOOFunction() { }


   /**
    * Get the responsible attribute of the IMultiLinkSearchSetOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.I_MULTILINK_SEARCH_SET.equals (methodName);
   }


   /**
    * MultiLink Set Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String objectName;
      String objectType;
      String lowerBoundObjectName;
      String upperBoundObjectName;
      String containerObjectName;
      String containerName;
      boolean generateLowerBoundName;
      boolean isEntryLink;
      String className;
      FType classType;
      OOExpression[] umlAttrValuePairs;

      try
      {
         objectName = (String) param[0];
         objectType = (String) param[1];
         lowerBoundObjectName = (String) param[2];
         upperBoundObjectName = (String) param[3];
         containerObjectName = (String) param[4];
         containerName = (String) param[5];
         generateLowerBoundName =  ((Boolean) param[6]).booleanValue();
         isEntryLink =  ((Boolean) param[7]).booleanValue();
         classType = (FType) param[8];
         className = (String) param[9];
         umlAttrValuePairs = (OOExpression[]) param[10];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".iMultiLinkSearchSet("
            + "objectName=" + objectName
            + ",objectType=" + objectType
            + ",lowerBoundObjectName=" + lowerBoundObjectName
            + ",upperBoundObjectName=" + upperBoundObjectName
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            + ",generateLowerBoundName=" + generateLowerBoundName
            + ",isEntryLink=" + isEntryLink
            + ",className=" + className
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" multilink set bind " + objectName +
         " : " + objectType + " iMultiLinkSearchSet"));

      OOVariable iteratorVar = null;
      OOVariable uniqueLowerBoundVar = null;

      iteratorVar = OO.variable (CGU.upFirstChar (objectName), OOVariableType.iFujabaIter);

      if (generateLowerBoundName)
      {
         uniqueLowerBoundVar = OO.variable (CGU.upFirstChar (lowerBoundObjectName),
            OOVariableType.iFujabaFor,
            CGU.upFirstChar (objectName));
      }
      else
      {
         uniqueLowerBoundVar = OO.variable (lowerBoundObjectName);
      }

      // HashSet filling
      OOStatement.add (statements, OO.varDecl (OOCollectionEnum.HASHTABLE, CGU.upFirstChar (containerName),
         OO.variable (objectName),
         OO.newObject (OOCollectionEnum.HASHTABLE, CGU.upFirstChar (containerName))));

      if (isEntryLink)
      {
         OOStatement.add (statements, OO.varDecl ("FWIterator", iteratorVar,
            OO.call (containerObjectName,
            OO.method (CGU.upFirstChar (containerName),
            OOMethodType.ITERATOR_OF_METHOD))));
      }
      else
      {
         OOStatement.add (statements, OO.varDecl ("FWIterator", iteratorVar,
            OO.call (containerObjectName,
            OO.method (CGU.upFirstChar (containerName),
            OOMethodType.ITERATOR_OF_METHOD),
            OO.identifier (uniqueLowerBoundVar))));
      }
      OOStatement.add (statements, OO.emptyLine());

      OOStatement.add (statements, OO.whileStat (OO.iterHasNext (iteratorVar, containerObjectName,
         OO.type (containerName), true)));
      OOStatement.add (statements, OO.startBlock());

      boolean typeCastNeeded = !objectType.equals (className);
      OOStatement.add (statements,  (classType == null ? OO.varDecl (className,
         OO.variable (OOVariableType.iFujabaTmpObject, className),
         OO.iterGet (iteratorVar)) :
         OO.varDecl (classType,
         OO.variable (OOVariableType.iFujabaTmpObject, className),
         OO.iterGet (iteratorVar))));
      OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iteratorVar)));
      OOStatement.add (statements, OO.emptyLine());

      if (upperBoundObjectName != null)
      {
         OOStatement.add (statements, OO.ifStat (OO.call (OOVariable.FUJABA_TMP_OBJECT,
            OOMethod.EQUALS_METHOD,
            OO.identifier (upperBoundObjectName))));
         OOStatement.add (statements, OO.startBlock());
         OOStatement.add (statements, new OOBreakStatement());
         OOStatement.add (statements, OO.endBlock ("fi"));
      }

      if (typeCastNeeded)
      {
         OOStatement.add (statements, OO.ensure (new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT,
            objectType)));
      }

      for (int i = 0; i < umlAttrValuePairs.length; i++)
      {
         OOStatement.add (statements, OO.ensure (umlAttrValuePairs[i]));
      }

      OOStatement.add (statements, OO.exprStat (OO.call (objectName,
         OOMethod.ADD_TO_SET_METHOD,
         OO.identifier (OOVariable.FUJABA_TMP_OBJECT))));
      // while Block
      OOStatement.add (statements, OO.endBlock ("while"));

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "IMultiLinkSearchSetOOFunction[]";
   }
}

/*
 * $Log: IMultiLinkSearchSetOOFunction.java,v $
 * Revision 1.14.2.1  2005/07/13 11:24:49  creckord
 * Fixed problem with objects of classes with same name but different packages
 *
 */
