/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;


/**
 * Class IMultiLinkSearchOptionalTopOOFunction
 *
 * @author    $Author: l3_g5 $
 * @version   $Revision: 1.14.2.4 $
 */
public class IMultiLinkSearchOptionalTopOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (IMultiLinkSearchOptionalTopOOFunction.class);


   /**
    * Default Constructor
    */
   public IMultiLinkSearchOptionalTopOOFunction() { }


   /**
    * Get the responsible attribute of the IMultiLinkSearchOptionalTopOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.I_MULTILINK_SEARCH_OPTIONAL_TOP.equals (methodName);
   }


   /**
    * Bound_Object ... Unbound_Optional_Object (Top) Describe <code>generateOOCode</code> method
    * here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String objectName;
      FType objectType;
      String objectTypeStr;
      String lowerBoundObjectName;
      String upperBoundObjectName;
      String containerObjectName;
      String containerName;
      boolean generateLowerBoundName;
      boolean isEntryLink;
      String className;
      OOExpression[] umlAttrValuePairs;

      // parse param
      try
      {
         objectName = (String) param[0];
         objectType = (FType) param[1];
         objectTypeStr = (String) param[2];
         lowerBoundObjectName = (String) param[3];
         upperBoundObjectName = (String) param[4];
         containerObjectName = (String) param[5];
         containerName = (String) param[6];
         generateLowerBoundName =  ((Boolean) param[7]).booleanValue();
         isEntryLink =  ((Boolean) param[8]).booleanValue();
         className = (String) param[9];
         umlAttrValuePairs = (OOExpression[]) param[10];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".iMultiLinkSearchOptionalTop("
            + "objectName=" + objectName
            + ",objectType=" + objectType
            + ",lowerBoundObjectName=" + lowerBoundObjectName
            + ",upperBoundObjectName=" + upperBoundObjectName
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            + ",generateLowerBoundName=" + generateLowerBoundName
            + ",isEntryLink=" + isEntryLink
            + ",className=" + className
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" multilink optional bind " + objectName +
         " : " + objectType));

      OOVariable iteratorName = OO.variable (CGU.upFirstChar (objectName), OOVariableType.iFujabaIter);
      OOVariable uniqueLowerBoundName = null;

      if (generateLowerBoundName)
      {
         uniqueLowerBoundName = OO.variable (CGU.upFirstChar (lowerBoundObjectName), OOVariableType.iFujabaFor,
            CGU.upFirstChar (objectName));
      }
      else
      {
         uniqueLowerBoundName = OO.variable (lowerBoundObjectName);
      }

      if (isEntryLink)
      {
         OOStatement.add (statements, OO.varDecl ("FWIterator",
            iteratorName,
            OO.call (containerObjectName,
            OO.method (CGU.upFirstChar (containerName),
            OOMethodType.ITERATOR_OF_METHOD))));
      }
      else
      {
         OOStatement.add (statements, OO.varDecl ("FWIterator",
            iteratorName,
            OO.call (containerObjectName,
            OO.method (CGU.upFirstChar (containerName),
            OOMethodType.ITERATOR_OF_METHOD),
            OO.identifier (uniqueLowerBoundName))));
      }

      // generate do-while loop
      OOStatement.add (statements, new OODoStatement());
      OOStatement.add (statements, OO.startBlock());

      OOStatement.add (statements, new OOTryStatement());
      OOStatement.add (statements, OO.startBlock());

      OOStatement.add (statements, OO.assignStat (objectName, OOIdentifierExpr.NULL_IDENTIFIER));

      OOStatement.add (statements, OO.ifStat (OO.iterHasNext (iteratorName, containerObjectName,
         OO.type (containerName), true)));
      OOStatement.add (statements, OO.startBlock());

      boolean typeCastNeeded = !objectType.getName().equals (className);

      if (upperBoundObjectName != null)
      {
         if (!typeCastNeeded)
         {
            OOStatement.add (statements, OO.varDecl (objectType,
               objectName,
               OO.typeCast (objectType,
               OO.iterGet (iteratorName))));
            OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iteratorName)));
         }
         else
         {
            OOStatement.add (statements, OO.assignStat (OOVariable.FUJABA_TMP_OBJECT,
               OO.iterGet (iteratorName)));
            OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iteratorName)));

            OOStatement.add (statements, OO.ensure (new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT,
               objectTypeStr)));
            OOStatement.add (statements, OO.assignStat (objectName,
               OO.typeCast (objectType,
               OOVariable.FUJABA_TMP_OBJECT)));
         }

         OOStatement.add (statements, OO.ifStat (OO.call (objectName,
            OOMethod.EQUALS_METHOD,
            OO.identifier (upperBoundObjectName))));
         OOStatement.add (statements, OO.startBlock());
         OOStatement.add (statements, OO.assignStat (objectName, OOIdentifierExpr.NULL_IDENTIFIER));
         OOStatement.add (statements, OO.endBlock());
      }
      else
      {
         if (!typeCastNeeded)
         {
            OOStatement.add (statements, OO.varDecl (objectType,
               objectName,
               OO.typeCast (objectType,
               OO.iterGet (iteratorName))));
            OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iteratorName)));
         }
         else
         {
            OOStatement.add (statements, OO.assignStat (OOVariable.FUJABA_TMP_OBJECT,
               OO.iterGet (iteratorName)));
            OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iteratorName)));

            OOStatement.add (statements, OO.ensure (new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT,
               objectTypeStr)));
            OOStatement.add (statements, OO.assignStat (objectName,
               OO.typeCast (objectType,
               OOVariable.FUJABA_TMP_OBJECT)));
         }
      }

      OOStatement.add (statements, OO.endBlock ("optional"));

      for (int i = 0; i < umlAttrValuePairs.length; i++)
      {
         OOStatement.add (statements, OO.ensure (umlAttrValuePairs[i]));
      }

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "IMultiLinkSearchOptionalTopOOFunction[]";
   }
}

/*
 * $Log: IMultiLinkSearchOptionalTopOOFunction.java,v $
 * Revision 1.14.2.4  2005/10/19 17:35:07  l3_g5
 * removed jdk1.5 dependency
 *
 */
