/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * Class IMultiLinkSearchOptionalBottomOOFunction
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
public class IMultiLinkSearchOptionalBottomOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (IMultiLinkSearchOptionalBottomOOFunction.class);


   /**
    * Default Constructor
    */
   public IMultiLinkSearchOptionalBottomOOFunction() { }


   /**
    * Get the responsible attribute of the IMultiLinkSearchOptionalBottomOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.I_MULTILINK_SEARCH_OPTIONAL_BOTTOM.equals (methodName);
   }


   /**
    * Bound_Object ... Unbound_Optional_Object (Bottom) Describe <code>generateOOCode</code>
    * method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String objectName;
      String upperBoundObjectName;
      boolean isForEach;

      // parse param
      try
      {
         objectName = (String) param[0];
         upperBoundObjectName = (String) param[1];
         isForEach =  ((Boolean) param[2]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".iMultiLinkSearchOptionalBottom("
            + "objectName=" + objectName
            + ",upperBoundObjectName=" + upperBoundObjectName
            + ",isForEach=" + isForEach
            );
      }

      LinkedList statements = new LinkedList();
      OOStatement.add (statements, OO.lineComment (" iMultiLinkSearchOptionalBottom"));
      OOStatement.add (statements, OO.endBlock());
      OOStatement.add (statements, OO.catchStat (OOExceptionExpr.SDM_EXCEPTION, OOVariable.FUJABA_EXCEPTION_VARIABLE));
      OOStatement.add (statements, OO.startBlock());
      OOStatement.add (statements, OO.endBlock ("try catch"));
      OOStatement.add (statements, OO.endBlock());
      OOStatement.add (statements, OO.whileStat (OO.not (OOVariable.FUJABA_SUCCESS), true));

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "IMultiLinkSearchOptionalBottomOOFunction[]";
   }
}

/*
 * $Log: IMultiLinkSearchOptionalBottomOOFunction.java,v $
 * Revision 1.14  2004/10/20 17:49:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
