/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FBaseTypes;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Class IMultiLinkSearchNormTopOOFunction
 *
 * @author    $Author: l3_g5 $
 * @version   $Revision: 1.14.2.3 $
 */
public class IMultiLinkSearchNormTopOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (IMultiLinkSearchNormTopOOFunction.class);


   /**
    * Default Constructor
    */
   public IMultiLinkSearchNormTopOOFunction() { }


   /**
    * Get the responsible attribute of the IMultiLinkSearchNormTopOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.I_MULTILINK_SEARCH_NORM_TOP.equals (methodName);
   }


   /**
    * Bound_Object ... Unbound_Norm_ Object (Top) Describe <code>generateOOCode</code> method
    * here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String objectName;
      FType objectType;
      String objectTypeStr;
      String lowerBoundObjectName;
      String upperBoundObjectName;
      String containerObjectName;
      String containerName;
      boolean generateLowerBoundName;
      String className;
      OOExpression[] umlAttrValuePairs;
      boolean isForEach;

      // parse param
      try
      {
         objectName = (String) param[0];
         objectType = (FType) param[1];
         objectTypeStr = (String) param[2];
         lowerBoundObjectName = (String) param[3];
         upperBoundObjectName = (String) param[4];
         containerObjectName = (String) param[5];
         containerName = (String) param[6];
         generateLowerBoundName =  ((Boolean) param[7]).booleanValue();
         className = (String) param[8];
         umlAttrValuePairs = (OOExpression[]) param[9];
         isForEach =  ((Boolean) param[10]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".iMultiLinkSearchNormTop("
            + "objectName=" + objectName
            + ",objectType=" + objectType
            + ",objectTypeStr=" + objectTypeStr
            + ",lowerBoundObjectName=" + lowerBoundObjectName
            + ",upperBoundObjectName=" + upperBoundObjectName
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            + ",generateLowerBoundName=" + generateLowerBoundName
            + ",className=" + className
            + ",isForEach=" + isForEach
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" multilink bind " +
         objectName +
         " : " + objectType +
         " iMultiLinkSearchNormTop"));

      OOVariable iteratorName = OO.variable (CGU.upFirstChar (objectName), OOVariableType.iFujabaIter);
      OOVariable upperBoundFlag = null;
      OOVariable uniqueLowerBoundName = null;

      OOCallMethodExpr iteratorMethodExpr = null;

      OOExpression fujabaSuccessExpr = null;
      OOExpression upperBoundExpr = null;
      OOExpression conditionExpr = null;
      OOExpression hasNextExpr = null;
      OOInfixExprLeft leftExpr = null;

      if (upperBoundObjectName != null)
      {
         upperBoundFlag = OO.variable (CGU.upFirstChar (objectName), OOVariableType.iFujabaUpperBound);
      }

      if (generateLowerBoundName)
      {
         uniqueLowerBoundName = OO.variable (CGU.upFirstChar (lowerBoundObjectName),
            OOVariableType.iFujabaFor,
            CGU.upFirstChar (objectName));
      }
      else
      {
         uniqueLowerBoundName = OO.variable (lowerBoundObjectName);
      }

      iteratorMethodExpr = OO.call (containerObjectName,
         OO.method (CGU.upFirstChar (containerName),
         OOMethodType.ITERATOR_OF_METHOD));

      if (lowerBoundObjectName != null)
      {
         iteratorMethodExpr.addToParameter (OO.identifier (uniqueLowerBoundName));
      }

      OOStatement.add (statements, OO.varDecl ("FWIterator",
         iteratorName,
         iteratorMethodExpr));

      if (upperBoundObjectName != null)
      {
         OOStatement.add (statements, OO.varDecl (UMLProject.get().getFromBaseTypes (FBaseTypes.BOOLEAN),
            upperBoundFlag,
            OOIdentifierExpr.FALSE_IDENTIFIER));
      }

      // generate the while loop
      if (!isForEach)
      {
         fujabaSuccessExpr = OO.not (OOVariable.FUJABA_SUCCESS);
      }

      hasNextExpr = OO.iterHasNext (iteratorName, containerObjectName, OO.type (containerName), true);

      if (upperBoundObjectName != null)
      {
         upperBoundExpr = OO.not (upperBoundFlag);
      }

      if (!isForEach)
      {
         leftExpr = OO.infixOp (fujabaSuccessExpr, OOInfixOp.AND_OP, hasNextExpr);
         if (upperBoundExpr != null)
         {
            leftExpr.append (OOInfixOp.AND_OP, upperBoundExpr);
         }
         conditionExpr = leftExpr;
      }
      else if (upperBoundExpr != null)
      {
         conditionExpr = OO.infixOp (hasNextExpr, OOInfixOp.AND_OP, upperBoundExpr);
      }
      else
      {
         conditionExpr = hasNextExpr;
      }

      OOStatement.add (statements, OO.whileStat (conditionExpr));
      OOStatement.add (statements, OO.startBlock());

      OOStatement.add (statements, new OOTryStatement());
      OOStatement.add (statements, OO.startBlock());

      boolean typeCastNeeded = !objectType.getName().equals (className);

      if (!typeCastNeeded)
      {
         OOStatement.add (statements, OO.varDecl (objectType,
            objectName,
            OO.typeCast (objectType,
            OO.iterGet (iteratorName))));
         OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iteratorName)));
         OOStatement.add (statements, OO.emptyLine());
      }
      else
      {
         OOStatement.add (statements, OO.varDecl (OO.type ("Object"), OO.variable (OOVariableType.iFujabaTmpObject), OO.iterGet (iteratorName)));
         OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iteratorName)));
         OOStatement.add (statements, OO.emptyLine());

         OOStatement.add (statements, OO.ensure (OO.infixOp (OO.notNullExpr (OOVariable.FUJABA_TMP_OBJECT),
            OOInfixOp.AND_OP,
            new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT, objectTypeStr))));

         OOStatement.add (statements, objectType == null ?
            OO.varDecl (objectTypeStr, objectName,
            OO.typeCast (objectType, OOVariable.FUJABA_TMP_OBJECT)) :
            OO.varDecl (objectType, objectName,
            OO.typeCast (objectType, OOVariable.FUJABA_TMP_OBJECT)));
      }

      if (upperBoundObjectName != null)
      {
         OOStatement.add (statements, OO.ifStat (OO.call (objectName,
            OOMethod.EQUALS_METHOD,
            OO.identifier (upperBoundObjectName))));
         OOStatement.add (statements, OO.startBlock());

         OOStatement.add (statements, OO.assignStat (upperBoundFlag, OOIdentifierExpr.TRUE_IDENTIFIER));
         OOStatement.add (statements, new OOThrowStatement (OOExceptionExpr.SDM_EXCEPTION));

         OOStatement.add (statements, OO.endBlock());
      }

      for (int i = 0; i < umlAttrValuePairs.length; i++)
      {
         OOStatement.add (statements, OO.ensure (umlAttrValuePairs[i]));
      }

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "IMultiLinkSearchNormTopOOFunction[]";
   }
}

/*
 * $Log: IMultiLinkSearchNormTopOOFunction.java,v $
 * Revision 1.14.2.3  2005/08/09 17:12:44  l3_g5
 * typecast needed check works again
 *
 */
