/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;

import de.uni_paderborn.fujaba.asg.ASGElementRef;
import de.uni_paderborn.fujaba.asg.ASGTransient;
import de.uni_paderborn.fujaba.metamodel.*;


/**
 * @author    <a href="mailto:creckord@upb.de">Carsten Reckord</a>
 * @version   $Revision: 1.3 $
 */
public abstract class GeneratedMethodRef extends ASGElementRef implements ASGTransient, FElementRef
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param method  No description provided
    * @return        No description provided
    */
   public static boolean hasGeneratedMethodRef (FMethod method)
   {
      Iterator iter = method.iteratorOfElementReferences();
      while (iter.hasNext())
      {
         ASGElementRef elementRef = (ASGElementRef) iter.next();
         if (elementRef instanceof GeneratedMethodRef)
         {
            return true;
         }
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param method  No description provided
    * @return        No description provided
    */
   public static boolean hasAccessedElement (FMethod method)
   {
      Iterator iter = method.iteratorOfElementReferences();
      while (iter.hasNext())
      {
         ASGElementRef elementRef = (ASGElementRef) iter.next();
         if (elementRef instanceof GeneratedMethodRef)
         {
            GeneratedMethodRef ref = (GeneratedMethodRef) elementRef;
            if (ref.getAccessedElement() != null)
            {
               return true;
            }
         }
      }
      return false;
   }


   /**
    * Get the accessedElement attribute of the AccessMethodRef object
    *
    * @return   The accessedElement value
    */
   public FElement getAccessedElement()
   {
      return  (getAccessedElementRef() == null ? null :
         getAccessedElementRef().getElement());
   }


   /**
    * Sets the method attribute of the AccessMethodRef object
    *
    * @param method  The new method value
    * @return        No description provided
    */
   public boolean setMethod (FMethod method)
   {
      return this.setElement (method);
   }


   /**
    * Get the method attribute of the AccessMethodRef object
    *
    * @return   The method value
    */
   public FMethod getMethod()
   {
      return (FMethod) this.getElement();
   }


   /**
    * <pre>
    *                  0..n          Assoc          0..1
    * AccessMethodRef ----------------------------------- AccessedElementRef
    *                  methodRef      accessedElementRef
    * </pre>
    *
    * @return   The accessedElementRef value
    */
   public abstract AccessedElementRef getAccessedElementRef();


   /**
    * Sets the accessedElementRef attribute of the AccessMethodRef object
    *
    * @param value  The new accessedElementRef value
    * @return       No description provided
    */
   public abstract boolean setAccessedElementRef (AccessedElementRef value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      AccessedElementRef tmpAccessedElementRef = getAccessedElementRef();
      if (tmpAccessedElementRef != null)
      {
         setAccessedElementRef (null);
      }
   }
}

/*
 * $Log: GeneratedMethodRef.java,v $
 * Revision 1.3  2004/10/22 16:41:33  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
